/*
    Slots
*/

class Slots extends React.Component {
    showSlotsList = () => {
        return this.props.slots.map((item, i) => {
            return (
                <SlotItem key={item.id} index={i} data={item} deleteSlot={(data) => this.props.deleteSlot(data)} editSlot={(data) => this.props.editSlot(data)} />
            )
        })
    };
    render() {
        if (this.props.slots) {
            return (
                <div className="form-group slot">
                    <div className="form-group-title">Слоты (slots):</div>
                    <div className="slots">
                        <input className="form-control" type="hidden" id="slots" name="slots" defaultValue="" />
                        {this.showSlotsList()}
                    </div>
                    <div>
                        <div className="btn-group">
                            <a role="button" className="btn btn-primary add-slot" href="#" onClick={(event) => this.props.addSlot(event)}>Добавить слот</a>
                        </div>
                    </div>
                </div>    
            );  
        } else {
            return (
                <div className="form-group slot">
                    <div className="form-group-title">Слоты (slots):</div>
                    <ClearBoth />
                </div>
            );  
        }
    }
}


function mapStateToProps(state) {
    return {
        slots: state.slots
    }
}

function matchDispatchToProps(dispatch) {
    return bindActionCreators({addSlot: addSlot, deleteSlot: deleteSlot, editSlot: editSlot}, dispatch);
}

const ConnectedSlots = connect(mapStateToProps, matchDispatchToProps)(Slots);
