/*
    AddField
    AddFieldElem
*/

class AddFieldElem extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            data: [],
            count: 0
        };
        var j = 0;
        if (this.props.data) {
            Object.keys(this.props.data).map(name => this.state.data.push([name, this.props.data[name], j++]));
            this.state.count = this.state.data.length;
        }
        this.onInputChange = this.onInputChange.bind(this);
    };
    remove = (i) => {
        var valuesList = this.state.data;
        valuesList.splice (i, 1);
        this.setState({data: valuesList});
        this.props.onEdit(this.state.data, this.props.name);
    };
    onInputChange(i, e){
        const name = e.target.name;
        var valuesList = this.state.data;
        if (name == 'name') {
            valuesList[i][0] = e.target.value;
        } else {
            valuesList[i][1] = e.target.value;
        }
        this.setState({data: valuesList});
        this.props.onEdit(this.state.data, this.props.name);
    };
    addField = () => {
        var {data, count} = this.state;
        data.push(['', '', count]);
        this.setState({data: data, count: count + 1});
        this.props.onEdit(this.state.data, this.props.name);
    };
    eachItem = (item, i) => {
        return (
            <div key={'k'+item[2]}  className="addition-field-item">
                <input type="text" className="form-control name" name="name" ind={i} onChange={this.onInputChange.bind(null, i)} value={item[0]} placeholder="поле" />&nbsp;
                <input type="text" className="form-control value" name="value" ind={i} onChange={this.onInputChange.bind(null, i)} value={item[1]} placeholder="значение" />
                <div className="delete-addition-field" onClick={this.remove.bind(null, i)}>&#215;</div>
            </div>    
        );
    };
    render() {
        return (
            <div className="addition-block-elem" data-title={this.props.title}>
                <span className="title">{this.props.title}</span>
                {this.state.data.map(this.eachItem)}
                <span className="addition-add-field" onClick={this.addField}>Добавить поле {this.props.title}</span>
            </div>
        );
    }
}

class AddField extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            data: this.props.data,
        };
    };
    onEdit = (data, name) => {
        var dataField = {};
        data.forEach(function(item) {
            dataField[item[0]] = item[1];
        });
        this.state.data[name] = dataField
    };
    /*
    onRemove = (i) => {
        console.log('AAA onRemove',i, e);
    };
    */
    render() {
        return (
            <div className="addition-block-item">
                <AddFieldElem data={this.state.data.b} onEdit={this.onEdit} name={"b"} title={"before"} />
                <AddFieldElem data={this.state.data.e} onEdit={this.onEdit} name={"e"} title={"elem"} />
                <AddFieldElem data={this.state.data.a} onEdit={this.onEdit} name={"a"} title={"after"} />
                <div className="delete-addition-block" onClick={this.props.onRemove.bind(null, this.props.index)}>&#215;</div>
                <ClearBoth />
            </div>
        );
    }
}