<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Entity;


/**
 * Class Support
 * @package App\Entity
 */
class Support extends Common implements IdentityInterface
{
    const ROLE_ADMIN = 'admin';
    const ROLE_MANAGER = 'manager';
    const ROLE_TRANSLATOR = 'translator';
    const ROLE_MARKER = 'marker';
    const ROLE_MANAGER_CPA = 'manager_cpa';
    const ROLE_TEASERMAKER_CPA = 'teasermaker_cpa';
    const ROLE_MANAGER_FEED = 'manager_feed';
    const ROLE_MANAGER_TPL = 'manager_tpl';

    protected $allowedRoles = [
        self::ROLE_ADMIN,
        self::ROLE_MANAGER,
        self::ROLE_TRANSLATOR,
        self::ROLE_MARKER,
        self::ROLE_MANAGER_CPA,
        self::ROLE_TEASERMAKER_CPA,
        self::ROLE_MANAGER_FEED,
        self::ROLE_MANAGER_TPL,
    ];

    protected $email;
    
    protected $fullname;

    protected $password;

    protected $role_id;

    protected $dateCreate;

    /**
     * @return mixed
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param mixed $email
     * @return Support
     */
    public function setEmail($email)
    {
        $this->email = $email;
        return $this;
    }
    
    /**
     * 
     * @return string
     */
    public function getFullname(): string
    {
        return $this->fullname;
    }
    
    /**
     * 
     * @param string $fullname
     * @return $this
     */
    public function setFullname($fullname)
    {
        $this->fullname = $fullname;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * @param mixed $password
     * @return Support
     */
    public function setPassword($password)
    {
        $this->password = $password;
        return $this;
    }

    /**
     * Returns the string identifier of the Role
     *
     * @return mixed
     */
    public function getRoleId()
    {
        return $this->role_id;
    }

    /**
     * @param string $role
     * @return Support
     */
    public function setRole(string $role) {
        return $this->setRoleId($role);
    }

    /**
     * @param string $role
     * @return $this
     * @throws \Exception
     */
    public function setRoleId(string $role)
    {
        if (in_array($role, $this->allowedRoles)) {
            $this->role_id = $role;
        } else {
            throw new \Exception("Unknown role '" . $role . "'");
        }
        return $this;
    }

    /**
     * @return mixed
     */
    public function getDateCreate()
    {
        return $this->dateCreate ?? (new \DateTimeImmutable())->format('Y-m-d H:i:s');
    }

    /**
     * @param mixed $dateCreate
     * @return Support
     */
    public function setDateCreate($dateCreate)
    {
        $this->dateCreate = $dateCreate;
        return $this;
    }

}