$(document).ready(function () {
    "use strict";
    
    /* Стр. категорий магазина */

    var
        $tableCats = $('.table.feeds-cats'),
        isChanged = 0,
        feedCatsStorageName = 'feedCatsOpenState',
        catsStateValue;

    // Покидание страницы:
    window.onbeforeunload = function(e) {
        if (isChanged) {
            return "Данные не сохранены. Закрыть страницу без сохранения?";
        }
    };
    
    // Разворачиваем категории фидов по стостоянию в localStorage:
    function ShowFeedsTablesStateByCats(feedsCatsState)
    {
        var $tr, $groupTr, $inheritedTr, $tableFeedCats, catsState;
        
        Object.keys(feedsCatsState).forEach(function(feedId){
            $tableFeedCats = $tableCats.filter('[data-feed-id="' + feedId + '"]');
            
            catsState = feedsCatsState[feedId];
            
            catsState.forEach(function(id){

                $tr = $('tbody tr[data-id="' + id + '"]', $tableFeedCats);
                $groupTr = $('.group', $tr);
                $inheritedTr = $('tbody tr[data-parent="' + id + '"]', $tableFeedCats);

                $tr.addClass('open');
                $groupTr.addClass('open');
                $inheritedTr.addClass('open');
            });
            
        });
    }
    
    // Разворачиваем категории таблиц фидов при старте:
    function ShowStartFeedsTablesState()
    {
        catsStateValue = JSON.parse(localStorage.getItem(feedCatsStorageName));
        if (catsStateValue) {
            ShowFeedsTablesStateByCats(catsStateValue);
        }
    }
    
    // Сохраняем раскрытые категории фида в localStorage:
    function SetFeedCatsStorage(feedId)
    {
        var
            $tableFeedCats = $tableCats.filter('[data-feed-id="' + feedId + '"]'),
            $tr = $('tbody tr', $tableFeedCats),
            currentState = JSON.parse(localStorage.getItem(feedCatsStorageName)),
            feedCatsStateValue = [];
        
        if (!currentState) {
            currentState = {};
        }
        
        $.each($tr, function() {
            var
                $trItem = $(this),
                $groupItem = $('.group', $trItem);
            if ($groupItem.hasClass('open')) {
                feedCatsStateValue.push($trItem.attr('data-id'));
            }
        });
        
        if (feedCatsStateValue.length) {
            currentState[feedId] = feedCatsStateValue;
        } else {
            if (currentState[feedId]) {
                delete currentState[feedId];
            }
        }
        
        // Проверяем localStorage на наличие полей:
        if (Object.keys(currentState).length) {
            localStorage.setItem(feedCatsStorageName,JSON.stringify(currentState));
        } else {
            localStorage.removeItem(feedCatsStorageName);
        }

    }

    // Свернуть-развернуть список категорий фида:
    $('.cat-title-main', $tableCats).on('click', function(e) {

        var
            $this = $(this),
            $group = $('.group', $this),
            $wrap = $tableCats,
            $allTrs = $('tr.feed-cat', $wrap),
            $groupAllTrs = $('.group', $allTrs),
            $mainTrs = $('tr.feed-cat[data-parent="0"]', $wrap),
            feedId = $this.parents('.table.feeds-cats').data('feed-id'),
            isOpen;
        
        $group.toggleClass('open');
        isOpen = $group.hasClass('open');

        if (isOpen) {
            $groupAllTrs.addClass('open');
            $allTrs.addClass('open');
        } else {
            $groupAllTrs.removeClass('open');
            $allTrs.removeClass('open');
            $mainTrs.addClass('open');
        }
        
        SetFeedCatsStorage(feedId);
    });

    // Свернуть-развернуть категории в списке:
    $('.cat-title', $tableCats).on('click', function(e) {

        var
            $this = $(this),
            $group = $('.group', $this),
            $wrap = $this.parents('.feed-cat').eq(0),
            id = $wrap.data('id'),
            $subcats,
            feedId = $this.parents('.table.feeds-cats').data('feed-id'),
            isOpen;

        $group.toggleClass('open');
        isOpen = $group.hasClass('open');

        $subcats = $('.feed-cat[data-parent="'+ id + '"]','.table.feeds-cats');


        if (isOpen) {
            $subcats.addClass('open');
        } else {
            $.each($subcats, function(i, item) {
                var $span = $('span.group', $(item));
                if ($span.hasClass('open')) {
                    $span.click();
                }
            });
            $subcats.removeClass('open');
        }

        SetFeedCatsStorage(feedId);
    });

    // Изменение значения процента для категории:
    $('tbody tr td.percent .edited', $tableCats).on('click', function(){

        var
            $field = $(this),
            $fieldValue = $('.percent-value', $field),
            $td = $field.parents('td.percent').eq(0),
            id = $td.parent().attr('data-id'),
            $wrap = $field.parent(),
            $inputWrap = $('.editing-wrap', $wrap),
            $input = $('.editing', $wrap),
            $oldValue = $('.old-value', $wrap),
            oldVal = $field.attr('data-old-value'),
            oldText = $fieldValue.html(),
            oldType = $td.attr('data-old-type'),
            $formActions = $('.form-actions');

        $oldValue.hide();

        $field.hide();
        $inputWrap.show();
        $input.off('blur').off('keyup').focus();

        $input.on('keyup', function(e) {

            if (e.keyCode == 13) {
                $input.blur();
            }

            if (e.keyCode == 27) {
                $input.off('blur');
                $input.val(oldVal);
                $fieldValue.html(oldText);
                $inputWrap.hide();
                $field.show();
            }

        });

        $input.on('blur', function() {

            var
                textInput = $input.val(),
                textField = textInput,
                typeValue,
                match, regex;

            // Убираем пробелы, разделитель точкой:
            textField = textField.replace(' ', '').replace(',', '.');

            if (textField != '') {
                // Проверка на число от 0.1 до 99.9 :
                regex = /^[0-9]*[.,]?[0-9]+$/g;
                match = regex.exec(textField)
                if (!match || (textField < 0.1) || textField > 99.9) {
                    textField = oldVal;
                    $input.val(oldVal)
                }
                
                $fieldValue.removeClass('empty');
                $td.removeClass('inherited').addClass('own');
            }

            $inputWrap.hide();
            $fieldValue.html(textField);

            // Очистили значение:
            if (textField == '') {
                
                $fieldValue.addClass('empty');
                $td.removeClass('own').addClass('inherited');
                
                var
                    parentValue,
                    parentId = $td.parent().attr('data-parent'),
                    $parentTr;
                
                if (parentId == 0) {
                    parentValue = $tableCats.attr('data-feed-percent');
                } else {
                    $parentTr = $('tbody tr[data-id="' + parentId + '"]', $tableCats);
                    parentValue = $('td .percent-input', $parentTr).val();
                }
                
                $fieldValue.html(parentValue);
                $input.val(parentValue);
                
                textField = parentValue;
            }

            // Прописываем значение у потомков c inherited:
            SetChildInheritedValue(id, textField);

            var valueType = $td.hasClass('own') ? 'own' : 'inherited';

            if (textField != oldVal) {
                $field.addClass('was-edited');
                $oldValue.show();
            } else {
                //$field.removeClass('was-edited');
                if (valueType != oldType) {
                    $field.addClass('was-edited');
                } else {
                    $field.removeClass('was-edited');
                }
                
                $oldValue.hide();
            }

            CheckDiff();
            $field.show();
        });

        function SetChildInheritedValue(id, val)
        {
            
            var
                $childTrs = $('tbody tr[data-parent="' + id + '"]', $tableCats);
                        
            $childTrs.each(function(){
                var
                    $childTr = $(this),
                    childId = $childTr.attr('data-id'),
                    $tdPercent = $('td.percent', $childTr);
            
                if ($tdPercent.hasClass('inherited') ) {

                    $('.percent-value', $tdPercent).text(val);
                    $('.percent-input', $tdPercent).val(val);

                    var $edited = $('.edited', $tdPercent);

                    if (val != $edited.attr('data-old-value')) {
                        $edited.addClass('was-changed');
                    } else {
                        $edited.removeClass('was-changed');
                    }

                    SetChildInheritedValue(childId, val);
                }
                
            });
        }

        function CheckDiff()
        {
            var isDiff = $('.table.feeds-cats tbody tr td.percent .edited.was-edited').length;
            isChanged = isDiff;

            if (isDiff) {
                $formActions.show();
            } else {
                $formActions.hide();
            }
        }
    });
    
    // Клик на "Сохранить":
    $('.btn.btn-primary.submit-action').on('click', function(){

        window.onbeforeunload = function() {};

        var
            $this = $(this),
            action = $this.attr('action'),
            method = $this.attr('method'),
            formData = new FormData(),
            cats = {};

        $('tbody tr td.percent .edited', $tableCats).each(function(){
            var
                $this = $(this),
                id, percentValue, feedId, catId, foreignId;

            if ($this.hasClass('was-edited')) {
                id = parseInt($this.parents('.feed-cat').eq(0).attr('data-id'));
                percentValue = ($('.percent-value', $this).hasClass('empty')) ? null : parseFloat($('.percent-value', $this).text().trim())*10;
                feedId = parseInt($this.parents('.feeds-cats').eq(0).attr('data-feed-id'));
                foreignId = parseInt($('.foreign-id', $this.parents('.feed-cat').eq(0)).attr('data-id'));
                cats[id] = {
                    'id' : id,
                    'fi' : feedId,
                    'fc' : foreignId,
                    'p' : percentValue,
                }
            }
        });

        formData.append('cats', JSON.stringify(cats));

        console.log('AAA catsData = ', cats);
        //return false;

        $.ajax(action, {
            type: method,
            data: formData,
            cache:false,
            contentType: false,
            processData: false,
            success: function(data) {
                console.log('AAA data = ', data);
                if(data) {
                    if(data.result === true && data.redirect) {
                        document.location.href = data.redirect;
                    }
                    if(data.result === false && data.msg) {
                        $.showMessage('error', data.msg);
                    }
                } 
            },
            error: function(rew, status, err) {
                console.log(status, err);
                $.showMessage('error', err);
            }
        });

        return false;
    });
    
    // Разворачиваем категории таблицы при старте:
    ShowStartFeedsTablesState();
    
});