;(function($){

	var jqPluginName = 'sortTable';

	var sortPlugin = function(element, options) {
            
            var self = this;

            var config = $.extend(true, {}, $.fn[jqPluginName].defaults, options);
            config.context = element;
            
            config.$columnItems = $(config.columnItems, config.context);
            
            this.addDataItems = function() {
                
                config.dataItems = [];
                config.$itemsRows = $(config.itemsRows, config.context);
                
                var $itemRow;
                config.$itemsRows.each(function(i, e){
                    $itemRow = $(e);
                    config.dataItems.push({
                        tr: $itemRow, // строка в таблице
                        //trHtml: $itemRow.get(0).outerHTML,
                        id: parseInt($.trim($('.item-id', $itemRow).text())),
                        timestamp: $.trim($('.item-timestamp', $itemRow).text()),
                        browser: $.trim($('.item-browser', $itemRow).text()),
                        country: $.trim($('.item-country', $itemRow).text()),
                        site: $.trim($('.item-site', $itemRow).text()),
                        offer: $.trim($('.item-offer', $itemRow).text()),
                        land: $.trim($('.item-land', $itemRow).text()),
                        status: $.trim($('.item-status', $itemRow).text()),
                        price: $.trim($('.item-price', $itemRow).text()),
                        views: parseInt($.trim($('.item-views', $itemRow).text())),
                        clicks: parseInt($.trim($('.item-clicks', $itemRow).text())),
                        ctr: parseFloat($.trim($('.item-ctr', $itemRow).text())),
                        orders: parseInt($.trim($('.item-orders', $itemRow).text())),
                        cl: parseFloat($.trim($('.item-cl', $itemRow).text())),
                        money: parseFloat($.trim($('.item-money', $itemRow).text())),
                        cpc: parseFloat($.trim($('.item-cpc', $itemRow).text())),
                        cpm: parseFloat($.trim($('.item-cpm', $itemRow).text())),
                    });
                });
            }
            
            this.addDataItems();
            
            self.InitData = function() {
                this.addDataItems();
            }
            
            // Клик по названию колонки для сортировки:
            config.$columnItems.click(function() {
                
                // Сортировка в таблице
                var
                    sortField = $(this).data('sort'),
                    sortAsc = $(this).attr('data-sortasc');
                    
                $(this).attr('data-sortasc', -sortAsc);

                config.dataItems.sort(function(a, b) {
                    if (sortAsc < 0) {
                        return (a[sortField] > b[sortField]) ? 1 : -1;
                    } else {
                        return (a[sortField] < b[sortField]) ? 1 : -1;
                    }
                });
                
                // Переписываем таблицу:
                var 
                    $table = $(config.context),
                    $tableBody = $('tbody', $table),
                    //$tableBody = $table.find('tbody').first(),
                    $tableContent = $('<tbody>');
                
                for (var i = 0; i < config.dataItems.length; i++) {
                    (config.dataItems[i].tr).appendTo($tableContent);
                }
                
                $tableBody.html('').append($tableContent.children());
                
            });
                
            config.context.data(jqPluginName, this);
	}

	$.fn[jqPluginName] = function(options) {
            return this.each(function() {
                var _this = $(this);
                if (!_this.data(jqPluginName))
                {
                    new sortPlugin(_this, options);
                }
            });
	}

	$.fn[jqPluginName].defaults = {
            context: null,
            dataItems: [],
            itemsRows: 'tbody tr',
            $itemsRows: null,
            columnItems: '.sort[data-sort]',
            $columnItems: null,
	}

})(jQuery);
