$(document).ready(function(){

    var
        $table = $('#table-line'),
        $tableHeader = $('<thead>'),
        $tableContent = $('<tbody>'),
        $tableBody = $table.find('tbody').first(),
        activeLinesSwitchSelector = '.b-filter__switch.current-metric:not(.metric-data) .b-filter__switch-item',
        $activeLinesSwitch = $(activeLinesSwitchSelector),
        selectorTableTimeSwitch = '.b-filter__switch.time-table .m-filter__switch-item_active',
        selectorActiveData = '.b-filter__switch.metric-data .m-filter__switch-item_active',
        timeTableType,
        activeLines = [],
        currentActiveLine,
        metric,
        dataTable,
        bySiteState = false;
    
    function valueFormat(value)
    {
        var
            currencyFields = ['admoney', 'salemoney'],
            isCurrencyValue = currencyFields.indexOf(currentActiveLine) > -1,
            format = (isCurrencyValue) ? d3.format(',.2f') : d3.format(',.0f');
    
        return format(value);
    }
    
    function RenderInterval(dataLineChartStat)
    {
        var dataPeriod = dataLineChartStat['period'],
            classTd;

        dataTable = dataLineChartStat;

        // Добавляем строку "Итого":
        $row = $('<tr style="font-weight: bold;">');
        $row.append($('<td>').html("Итого"));
        activeLines.forEach(function(item){
            currentActiveLine = item;
            
            var totalValue = 0;
            for(var i = dataPeriod.length-1; i >= 0; i--) {
                totalValue += dataTable[item][i];
            }

            $row.append($('<td>').html(valueFormat(totalValue)));
        });
        $row.appendTo($tableContent);

        for(var i = dataPeriod.length-1; i >= 0; i--) {

            var
                date = dataPeriod[i],
                values = {};

            activeLines.forEach(function(activeLine){
                currentActiveLine = activeLine;
                values[activeLine] = valueFormat(dataTable[activeLine][i]);
            });

            $row = $('<tr>');
            $row.append($('<td>').html(date));
            activeLines.forEach(function(item){
                $row.append($('<td>').html(values[item]));
            });
            $row.appendTo($tableContent);
        }
    }
    
    $.extend({
        TableStat: {
            Render: function(dataLineChartStat) {
                
                // Формируем список переключателей (категорий) activeLines:
                activeLines = ['shows', 'clicks', 'transactions', 'salemoney', 'admoney'];

                //console.log('AAA TableStat render: ', dataLineChartStat);
                //console.log('AAA activeLines: ', activeLines);

                dataTable = {};
                activeLines.forEach(function(item){
                    dataTable[item] = [];
                });

                $table.removeClass('compare');
                $('thead', $table).removeClass('sortable');


                if (dataLineChartStat.type == 'interval') {
                    RenderInterval(dataLineChartStat);
                }

                $tableBody.html('').append($tableContent.children());
                
            },
            // Определяем список сайтов (зон, стиран) отмеченных галочками в таблице
            CheckedCategories: function() {
                var listSites = [];
                $('input', $table).each(function(){
                    if ($(this).is(":checked")) {
                        if (!isNaN(parseInt($(this).attr('id')))) {
                            listSites.push(parseInt($(this).attr('id')));
                        } else {
                            listSites.push($(this).attr('id'));
                        }
                    }
                })
                return (listSites.length == 0) ? false : listSites;
            },
            // Устанавливаем состояние "по сайту" (при клике на сайт в таблице)
            SetSiteState: function(state) {
                bySiteState = state;
            },
            // Получаем состояние "по сайту"
            GetSiteState: function() {
                return bySiteState;
            },
        }
    });

});

