<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Hydrator;


use Zend\Hydrator\ClassMethods;
use Zend\Hydrator\NamingStrategy\MapNamingStrategy;
use App\Hydrator\Strategy\Data as DataStrategy;

/**
 * Class Blockers
 * @package App\Hydrator
 */
class Blockers extends ClassMethods
{
    /**
     * Blockers constructor.
     * @param array|bool $underscoreSeparatedKeys
     */
    public function __construct($underscoreSeparatedKeys = true)
    {
        $dataPropertiesMapping = [
            \App\Entity\Statistic\Blockers::PROP_FIRST => 'first',
            \App\Entity\Statistic\Blockers::PROP_SECOND => 'second',
            \App\Entity\Statistic\Blockers::PROP_THIRD => 'third',
            \App\Entity\Statistic\Blockers::PROP_FORTH => 'forth',
        ];


        parent::__construct($underscoreSeparatedKeys);

        $this->setNamingStrategy(new MapNamingStrategy($dataPropertiesMapping));
        foreach ($dataPropertiesMapping as $alias => $property) {
            $this->addStrategy($alias, new DataStrategy(\App\Hydrator\Strategy\Data::EXTRACT_PERCENT));
        }

    }

}