<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Model;


/**
 * Class Locales
 * @package App\Model
 */
class Locales
{

    const LANG_EN = 'en';
    const LANG_DE = 'de';
    const LANG_RU = 'ru';
    const LANG_UK = 'uk';
    const LANG_FR = 'fr';
    const LOCALE_EN = 'en_US';
    const LOCALE_DE = 'de_DE';
    const LOCALE_RU = 'ru_RU';
    const LOCALE_UA = 'uk_UA';
    const LOCALE_FR = 'fr_FR';

    const DEFAULT_LANG = self::LANG_EN;
    const DEFAULT_LANG_ADMIN = self::LANG_RU;

    protected $available = [
        self::LANG_EN => self::LOCALE_EN,
//        self::LANG_DE => self::LOCALE_DE,
        self::LANG_RU => self::LOCALE_RU,
//        self::LANG_UK => self::LOCALE_UA,
//        self::LANG_FR => self::LOCALE_FR,
    ];

    /**
     * @return array
     */
    public function getLanguages()
    {
        return array_keys($this->available);
    }

    /**
     * @return array
     */
    public function getLocales()
    {

        return $this->available;
    }

    /**
     * @param $lang
     * @return string
     */
    public function getLocaleByLang($lang)
    {
        return $this->available[$lang] ?? $this->available[self::DEFAULT_LANG];
    }
}