<?php
/**
 * Copyright (c) 2017 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */


use Zend\Mail\Transport\SmtpOptions;

return [
    // Provides application-wide services.
    // We recommend using fully-qualified class names whenever possible as
    // service names.
    'dependencies' => [
        'factories' => [
            \Zend\Mail\Transport\SmtpOptions::class => function (\Interop\Container\ContainerInterface $container) {
                $googleOptions = new SmtpOptions($container->get('config')['google-mail-options']);
                return $googleOptions;
            },
            \Zend\Mail\Transport\Smtp::class => function (\Interop\Container\ContainerInterface $container) {
                $transport = new \Zend\Mail\Transport\Smtp();
                $transport->setOptions($container->get(\Zend\Mail\Transport\SmtpOptions::class));
                return $transport;
            },
            \App\Service\Mailer::class => function (\Interop\Container\ContainerInterface $container) {
                return new \App\Service\Mailer(
                    $container->get(\Zend\Mail\Transport\Smtp::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container->get(\App\Authentication\Tokenizer\Confirmation::class),
                    $container->get(\Zend\Hydrator\DelegatingHydrator::class),
                    [
                        \App\Service\Mailer::MAIL_NO_REPLY => 'no-reply@addcpm.com',
                        \App\Service\Mailer::MAIL_FOR_FEEDBACK => 'customer@addcpm.com',
                        \App\Service\Mailer::MAIL_APPLY_VACANCY => 'customer@addcpm.com',
                    ],
                    $container->get(\Monolog\Logger::class)
                );
            }
        ],
    ],
    'google-mail-options' => [
        'host' => 'smtp.gmail.com',
        'port' => 587,
        'connection_class' => 'login',
        'connection_config' => [
//            'username' => 'noadtech.mirror@gmail.com',
//            'password' => 'zaqwsx123',
            'username' => 'no-reply@addcpm.com',
            'password' => 'fkg&H4f3V^',
            'ssl' => 'tls',
        ],
    ],
];