<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Action\User;

use App\Action\Common;
use App\Authentication\UserService;
use App\Model\Users;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Zend\Diactoros\Response\HtmlResponse;
use Zend\Diactoros\Response\JsonResponse;
use Zend\Diactoros\Response\RedirectResponse;
use Zend\Hydrator\DelegatingHydrator;


/**
 * Class Campaigns
 * @package App\Action\User
 */
class Campaigns extends Common
{
    const ACTION_LIST = 'list';

    /**
     * @param ServerRequestInterface $request
     * @param ResponseInterface $response
     * @param callable|null $next
     * @return HtmlResponse
     */
    function __invoke(ServerRequestInterface $request, ResponseInterface $response, callable $next = null)
    { 
        
        if($request->getMethod() == 'POST') {
            /*
            try {
                switch ($request->getAttribute('action')) {
                    case self::ACTION_STAT:
                        $response = $this->getStatData($request);
                        break;
                    case self::ACTION_CATS:
                        $response = $this->editCatsData($request);
                        break;
                    default:
                }
            } catch(\Exception $e) {
                $data = [
                    'result' => false,
                    'msg' => $e->getMessage(),
                ];
                $response = new JsonResponse($data);
            }
            return $response;
            */
        }
        elseif($request->getAttribute('action') == self::ACTION_LIST)
        {
            
            return new HtmlResponse('Campaigns LIST');
            
            try {

                /** @var UserService $auth */
                $auth = $this->container->get(UserService::class);
                $userId = $auth->getIdentity()->getId();

                /** @var \App\Model\Feeds\Shops $shopsModel */
                $shopsModel = $this->container->get(\App\Model\Feeds\Shops::class);
                $shop = $shopsModel->findOne(['users_id' => $userId]);
                if($shop) {
                    $shop_title = $shop->getTitle();
                }
                
                /** @var \App\Model\Feeds $feedsModel */
                $feedsModel = $this->container->get(Feeds::class);
                $feeds = $feedsModel->findAll(['clientid' => $userId])->toArray();
                
                if ($feeds) {
                    
                    // Фиды пользователя:
                    $feed_id_list = [];
                    foreach($feeds as $feed_item) {
                        $feed_id = $feed_item['id'];
                        if (!in_array($feed_id, $feed_id_list)) {
                            $feed_id_list[] = $feed_id;
                        }
                    }

                    $report_type = $request->getAttribute('report');

                    // Текущий месяц:
                    $current_period = 'current_month';
                    $dates = [date('Y-m-01'), date('Y-m-d')];

                    $reports_conf = $this->container->get('config')['feed_conf']['reports'];
                    $report_conf = $reports_conf[$report_type];
                    
                    // Список отчетов:
                    $reports_list = [];
                    foreach($reports_conf as $report_name => $report_value) {
                        $reports_list[$report_name] = $report_value['title'];
                    }
                    
                    switch ($report_type) {
                        case 'common':
                            $periodStats = $stats->getFeedStatData($report_type, $feed_id_list, $dates, $report_conf);
                            break;
                        case 'transactions':
                            $periodStats = $stats->getFeedStatData($report_type, $feed_id_list, $dates, $report_conf);
                            break;
                        default:
                            $data['error'] = _t('Извините, тип отчета "'. $report_type .'" недоступен');
                            break;
                    }
                    
                    // Добавляем спец. категории для сводного отчета по магазину:
                    if ($report_type == 'common') {
                        $periodStats = $this->addStatsSpecialCats($periodStats);
                    }
                    
                    // Добавляем данные о статусах заказов:
                    if ($report_type == 'transactions') {
                        if ($periodStats) {
                            /** @var \App\Model\Feeds $ordersStatusModel */
                            $ordersStatusModel = $this->container->get(OrdersStatus::class);
                            $ordersStatus = $ordersStatusModel->findAll(['feed_id' => $feed_id_list])->toArray();
                            $statuses = [];
                            foreach($ordersStatus as $order_item) {
                                $statuses[$order_item['feed_id']][$order_item['order_id']] = array(
                                    'confirmed' => $order_item['confirmed'] ? 1 : 0,
                                    'approved' => $order_item['approved'] ? 1 : 0
                                );
                            }
                            $periodStats['ordersStatus'] = $statuses;
                        }
                    }
                    
                    $data['shop_title'] = $shop_title;
                    $data['feeds'] = $feeds;
                    $data['current_report'] = $report_type;
                    $data['current_period'] = $current_period;
                    $data['dates'] = $dates;
                    $data['periodStats'] = $periodStats;
                    $data['report_conf'] = $report_conf;
                    $data['reports_list'] = $reports_list;
                    $data['periods_list'] = $this->container->get('config')['feed_conf']['periods_list'];
                    $data['colors_active_lines'] = $this->container->get('config')['feed_conf']['colors_active_lines'];
                    
                } else {
                    $data['error'] = _t('Извините, у пользователя нет фидов');
                }

            } catch(\Exception $e) {
                $data['error'] = _t('Извините, статистика временно не работает');
            }

            $data = array_merge($data, [
                'lang' => $request->getAttribute('layoutInfo')->getLang(),
                'layoutInfo' => $request->getAttribute('layoutInfo'),
            ]);     

            return new HtmlResponse($this->template->render('app::user/cabinet-feed', $data));
        }
        
    }
    
    
}