<?php
/**
 * Copyright (c) 2017 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Action\User;


use App\Action\Common;
use App\Service\Mailer;
use App\Model\Users;
use Monolog\Logger;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Zend\Diactoros\Response\JsonResponse;
use Zend\Validator\EmailAddress;

/**
 * Class PasswordReset
 * @package App\Action\User
 */
class PasswordReset extends Common
{

    /**
     * @param ServerRequestInterface $request
     * @param ResponseInterface $response
     * @param callable|null $next
     * @return ResponseInterface|JsonResponse
     */
    function __invoke(ServerRequestInterface $request, ResponseInterface $response, callable $next = null)
    {
        $data = $request->getParsedBody();
        if (isset($data['email'])) {
            $validator = new EmailAddress();
            if ($validator->isValid($data['email'])) {
                /** @var Users $usersModel */
                $usersModel = $this->container->get(Users::class);
                $user = $usersModel->findOne(['email' => $data['email']]);
                if ($user) {
                    $pass = $usersModel->generateRandomPassword();
                    $password = $usersModel->hashPassword($pass);
                    $user->setPassword($password);
                    try {
                        $usersModel->save($user);

                        /** @var Mailer $mailer */
                        $mailer = $this->container->get(Mailer::class);
                        $mailer->sendRestorePassword($user, $pass, $request->getAttribute('layoutInfo')->getLang());

                        $response = new JsonResponse([
                            'result' => true,
                            'redirect' => $this->router->generateUri('user.mail.sent.password'),
                        ]);
                    } catch (\Exception $e) {
                        /** @var Logger $log */
                        $log = $this->container->get(Logger::class);
                        $log->error($e->getMessage(), ['trace' => $e->getTraceAsString()]);
                        $response = new JsonResponse(
                            [
                                'result' => false,
                                'msg' => _t('Error reset password. Try again later'),
                            ]
                        );
                    }

                } else {
                    $response = new JsonResponse([
                        'result' => false,
                        'msg' => _t('User doesn\'t exists'),
                    ]);
                }

            } else {
                $response = new JsonResponse(['result' => false, 'msg' => $validator->getMessages()]);
            }
        }
        return $response;
    }
}