<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Entity;


use App\Model\Locales;
use Psr\Http\Message\ServerRequestInterface;
use Slim\Flash\Messages;
use Zend\Expressive\Router\RouterInterface;
use \Zend\Permissions\Acl\AclInterface;

/**
 * Class LayoutInfo
 * @package App\Entity
 */
class LayoutInfo
{

    /**
     * @var string
     */
    protected $lang;

    /**
     * @var Locales
     */
    protected $locales;

    protected $phones = [];

    protected $skypes = [];

    protected $mails = [];
    /**
     * @var RouterInterface
     */
    protected $router;   
    
    /**
     * @var ServerRequestInterface
     */
    protected $request;
    /**
     * @var Messages
     */
    protected $flash;
    /**
     * @var bool
     */
    protected $enableLogin;       
    
    

    /**
     * @param string $langCode
     * @return $this
     */
    public function setLang($langCode = 'en')
    {
        $this->lang = $langCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getLang(): string
    {
        return $this->lang;
    }

    /**
     * @param Locales $locales
     */
    public function setLocales(Locales $locales)
    {
        $this->locales = $locales;
    }

    /**
     * @return Locales
     */
    public function getLocales(): Locales
    {
        return $this->locales;
    }

    /**
     * @return RouterInterface
     */
    public function getRouter(): RouterInterface
    {
        return $this->router;
    }
    
    public function getAcl(): AclInterface
    {
        return $this->acl;
    }

    /**
     * @param RouterInterface $router
     * @return LayoutInfo
     */
    public function setRouter(RouterInterface $router): LayoutInfo
    {
        $this->router = $router;
        return $this;
    }

    /**
     * @param ServerRequestInterface $request
     * @return $this
     */
    public function setRequest(ServerRequestInterface $request)
    {
        $this->request = $request;
        return $this;
    }

    /**
     * @return ServerRequestInterface
     */
    public function getRequest(): ServerRequestInterface
    {
        return $this->request;
    }

    /**
     * @param $flash
     * @return $this
     */
    public function setFlash($flash)
    {
        $this->flash = $flash;
        return $this;
    }

    /**
     * @return Messages
     */
    public function getFlash()
    {
        return $this->flash;
    }

    /**
     * @return array
     */
    public function getPhones(): array
    {
        return $this->phones;
    }

    /**
     * @param array $phones
     * @return LayoutInfo
     */
    public function setPhones(array $phones): LayoutInfo
    {
        $this->phones = $phones;
        return $this;
    }

    /**
     * @return array
     */
    public function getSkypes(): array
    {
        return $this->skypes;
    }

    /**
     * @param array $skypes
     * @return LayoutInfo
     */
    public function setSkypes(array $skypes): LayoutInfo
    {
        $this->skypes = $skypes;
        return $this;
    }

    /**
     * @return array
     */
    public function getMails(): array
    {
        return $this->mails;
    }

    /**
     * @param array $mails
     * @return LayoutInfo
     */
    public function setMails(array $mails): LayoutInfo
    {
        $this->mails = $mails;
        return $this;
    }
    
    public function setAcl(AclInterface $acl): LayoutInfo
    {
        $this->acl = $acl;
        return $this;
    }

    /**
     * @param $enabled
     * @return $this
     */
    public function enableLogin($enabled)
    {
        $this->enableLogin = $enabled;
        return $this;
    }

    /**
     * @return bool
     */
    public function isEnableLogin()
    {
        return $this->enableLogin;
    }

}