<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Validator;


use App\Entity\User as UserEntity;
use Zend\Validator\Digits;
use Zend\Validator\EmailAddress;
use Zend\Validator\Hostname;
use Zend\Validator\Uri;
use Zend\Validator\ValidatorInterface;

class User extends Common
{

    const EMAIL = 'email';
    const FULLNAME = 'fullname';    
    const USERTYPEID = 'user_type_id';

    protected $_validators = [
        self::EMAIL => EmailAddress::class,
        self::FULLNAME => [],        
        self::USERTYPEID => Digits::class,
    ];

    protected $messageTemplates = [
        self::EMAIL => '',
        self::FULLNAME => '',        
    ];

    /**
     * Returns true if and only if $value meets the validation requirements
     *
     * If $value fails validation, then this method returns false, and
     * getMessages() will return an array of messages that explain why the
     * validation failed.
     *
     * @param mixed $user
     * @return bool
     * @internal param mixed $value
     */
    public function isValid($user)
    {
        /** @var UserEntity $user */
        $result = parent::isValid($user);
        //@todo check validation rules & move common code into Validator\Common;
        return $result;
        
        $data = $this->hydrator->extract($user);
        
        /** @var ValidatorInterface $validator */
        foreach ($this->_validators as $property => $validator) {
            if (!$validator->isValid($data[$property])) {
                $this->error($property, $data[$property]);
                $result = false;
            }
        }
        return $result;
    }

    protected function validateInstance($entity)
    {
        return $entity instanceof UserEntity;
    }
}