$(document).ready(function () {
    "use strict";
    function uidGenerator() {
        var S4 = function () {
            return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
        };
        return (S4() + S4());
    }

    $("[data-menu]").affix({
        offset: {top: 60}
    });
    $(".b-content__knowledge").on("click", function (e, withoutScroll) {
        var uid;
        var cloned;
        var dataAction = (e.toElement || e.target).getAttribute("data-action");
        switch (dataAction) {
        case "skill-remove":
            e.stopPropagation();
            $(e.toElement).parents(".b-content__knowledge-item").remove();
            break;
        case "skill-add":
            cloned = $(".b-content__knowledge-item.hidden").clone(true, true).toggleClass("hidden");

            uid = uidGenerator();
            $("label[for='id-skill-new']", cloned).attr("for", uid);
            $("textarea#id-skill-new", cloned).attr("id", uid);
            $(".b-content__knowledge-inner").append(cloned);
            if (!withoutScroll) {
                $("html, body").animate({
                    scrollTop: cloned.offset().top - 30 //padding to avoid menu
                }, 400);
            }
            break;
        }
    });

});


