$(document).ready(function () {
    "use strict";
    
    // Работа со списками на стр. списка партнерок:
    (function(){
        
        var
            $selectAllItems = $('table.partners thead tr th input.select-all'),
            $actions = $('table.partners thead tr th b.action'),
            $applyButton = $('button.btn.btn-primary.apply');
        
        // Клик на галочку "Выбрать все":
        $selectAllItems.on('change', function(){
            
            var
                $this = $(this),
                isSelected = $this.prop('checked'),
                $tableTr = $('table.partners tbody tr');
            
            if (isSelected) {
                $tableTr.each(function(){
                    $('input.is-active', $(this)).prop('checked', true);
                });
                $actions.removeClass('hidden');
            } else {
                $tableTr.each(function(){
                    $('input.is-active', $(this)).prop('checked', false);
                });
                $actions.addClass('hidden');
            }
            
        });
        
        // Клик на галочку в списке:
        $('table.partners').on('change', 'input.is-active', function(){
            
            var offersIsCheched = false;
                
            $('table.partners input.is-active').each(function(){
                if ($(this).is(':checked')) {
                    offersIsCheched = true;
                }
            });
            
            if (offersIsCheched) {
                $actions.removeClass('hidden');
                $selectAllItems.prop('checked', true);
            } else {
                $selectAllItems.prop('checked', false);
                $actions.addClass('hidden');
            }
            
        });

        // Выбор действия с выделенными элементами:
        $actions.on('click', function(){
            
            var
                $this = $(this),
                actionType = $this.hasClass('activate') ? 'active' : 'disable',
                $wrap = $this.parents('.panel-body'),
                selectedItemsId = [];

            $('table tbody tr', $wrap).each(function() {
                var $item = $(this);
                if ($('input.is-active', $item).is(':checked')) {
                    selectedItemsId.push($item.data('id'));
                }
            });
            
            // Запрос на изменение статуса выбранных офферов:
            if (selectedItemsId.length > 0) {

                var
                    action = $('table', $wrap).data('action'),
                    method = 'POST',
                    data = {
                        'toggle_active': 1,
                        'is_active': (actionType == 'active') ? 1 : 0,
                        'id_items': selectedItemsId,
                    };
                    
                $.ajax(action, {
                    type: method,
                    data: data,
                    success: function(data) {
                        document.location.reload();
                    },
                    error: function(rew, status, err) {
                        console.log(status, err);
                    }
                });

            }

        });
        
    })();
    
    // Клик на "Сохранить" партнёрку:
    $('#partner-create-form').on('submit', function(e) {
        
        var
            formData = {},
            action = $(this).attr('action'),
            method = $(this).attr('method');
        
        var vals = $(this).serializeArray();
        if(vals.length) {
            for(var i in vals) {
                formData[vals[i].name] = vals[i].value;
            }
        }
        
        $.ajax(action, {
            type: method,
            data: formData,
            success: function(data) {
                if(data) {
                    if(data.result === true && data.redirect) {
                        document.location.href = data.redirect;
                    }
                    if(data.result === false && data.msg) {
                        $.showMessage('error', data.msg);
                    }
                } 
            },
            error: function(rew, status, err) {
                console.log(status, err);                    
            }
        });
        return false;
    });
    
});