<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Action;


use App\Authentication\UserService;
use App\Model\Sites;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Zend\Diactoros\Response\JsonResponse;
use Zend\Hydrator\DelegatingHydrator;
use Zend\Validator\Uri;

/**
 * Class Site
 * @package App\Action
 */
class Site extends Common
{

    const ADD = 'add-site';
    const REMOVE = 'remove-site';

    /**
     * @param ServerRequestInterface $request
     * @param ResponseInterface $response
     * @param callable|null $next
     * @return JsonResponse
     * @throws \Exception
     */
    function __invoke(ServerRequestInterface $request, ResponseInterface $response, callable $next = null)
    {
        $this->initInfo($request);

        $method = $request->getAttribute('method');

        //@todo add validation

        /** @var Sites $sites */
        $sites = $this->container->get(Sites::class);
        /** @var UserService $auth */
        $auth = $this->container->get(UserService::class);
        /** @var DelegatingHydrator $hydrator */
        $hydrator = $this->container->get(DelegatingHydrator::class);

        $result = false;
        $msg['text'] = 'Unknown error';
        $redirect = false;
        switch ($method) {
            case self::ADD:
                $domain = $request->getParsedBody()['site'];
                $site = $sites->findOne(['domain' => $domain]);
                if ($site) {
                    $result = false;
                    $msg = 'Domain \'' . $domain . '\' already registered';
                } else {
                    $validator = new Uri();
                    if ($validator->isValid($domain)) {
                        $site = $hydrator->hydrate(['users_id' => $auth->getIdentity()->getId(), 'domain' => $domain], new \App\Entity\Site());
                        /** @noinspection PhpParamsInspection */
                        $result = (bool) $sites->save($site);
                        if ($result) {
                            $msg['text'] = 'Success';
                            $site = $sites->findOne(['domain' => $domain]);
                            if (!$site) {
                                $site = new \App\Entity\Site();
                            }
                            $redirect = $this->router->generateUri('install.counter', ['siteId' => $site->getId()]);
                        } else {
                            $msg['text'] = 'DB error';
                        }
                    } else {
                        throw  new \Exception(implode(PHP_EOL, $validator->getMessages()));
                    }
                }
                break;
            case self::REMOVE:
                $id = $request->getAttribute('id');
                $result = (bool) $sites->delete($id, $auth->getIdentity()->getId());
                if (!$result) {
                    $msg['text'] = 'not deleted';
                }
                break;
            default:
                $result = false;
                break;
        }

        $data = ['result' => $result, 'msg' => $msg, 'redirect' => $redirect];

        return new JsonResponse($data);
    }
}