<?php

use Interop\Container\ContainerInterface;

return [
    'dependencies' => [
        'invokables' => [
            Zend\Expressive\Router\RouterInterface::class => Zend\Expressive\Router\ZendRouter::class,
        ],
        'factories' => [
            App\Action\Index::class => function (ContainerInterface $container) {
                return new App\Action\Index(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\TestReact::class => function (ContainerInterface $container) {
                return new \App\Action\TestReact(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
        ],
    ],

    'routes' => [
        [
            'name' => 'home',
            'path' => '/[:path]',
            'middleware' => App\Action\Index::class,
            'allowed_methods' => ['GET'],
            'options' => [
                'constraints' => [],
                'defaults' => []
            ],
        ],
        [
            'name' => 'test-react',
            'path' => '/test-react/',
            'middleware' => App\Action\TestReact::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [],
                'defaults' => []
            ],
        ],
    ],
];
