/*
    SiteForm
*/

class SiteForm extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            error: null,
            isLoaded: false,
        };
    };
    componentDidMount = () => {
        fetch("/test-react/", {method: 'POST'})
            .then(res => res.json())
            .then(
                (result) => {
                    console.log('AAA success ', result);
                    this.setState({
                        isLoaded: true,
                    });
                    this.props.onLoadedData(result);
                },
                (error) => {
                    console.log('AAA error');
                    this.setState({
                        isLoaded: true,
                        error
                    });
                }
            )
    };
    componentWillUnmount = () => {
        console.log('AAA componentWillUnmount');
    };
    onSubmitForm = (e) => {
        console.log('AAA onSubmitForm ', store.getState());
        e.preventDefault();
    };
    render() {
        const {error, isLoaded} = this.state;
        if (error) {
            return <div>Error: {error.message}</div>;
        } else if (!isLoaded) {
            return <div>Loading...</div>;
        } else {
            return (
                <form id="site-form" method="POST" action="/test-react">
                    <div className="form-group-data marker">
                        <ConnectedService />
                        <ConnectedSlots />
                        <ConnectedZones />
                        <ConnectedCodes />
                        <ConnectedHidezones />
                        <ConnectedStophide />
                        <ConnectedProviders />
                    </div>
                    <a className="btn btn-primary submit-action" href="#" datatype="save" onClick={this.onSubmitForm}>Сохранить</a>
                </form>
            );
        }
    }
}

function mapStateToProps(state) {
    return {
        data: state.data
    }
}
function matchDispatchToProps(dispatch) {
    return bindActionCreators({onLoadedData: onLoadedData}, dispatch);
}
const ConnectedSiteForm = connect(mapStateToProps, matchDispatchToProps)(SiteForm);
