<?php

namespace App\Action;

use App\Action\Common;

use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Zend\Diactoros\Response\HtmlResponse;
use Zend\Diactoros\Response\JsonResponse;


/**
 * Class TestReact
 * @package App\Action\Admin
 */
class TestReact extends Common
{
    
    /**
     * @param ServerRequestInterface $request
     * @param ResponseInterface $response
     * @param callable|null $next
     * @return HtmlResponse
     */
    function __invoke(ServerRequestInterface $request, ResponseInterface $response, callable $next = null)
    {
        if ($request->getMethod() == 'POST')
        {
            $action = $request->getAttribute('action');
            return $this->getTestData();
        }
        else
        {
            $response =  new HtmlResponse($this->template->render('app::react/testredux', [
                'layout' => 'empty',
            ]));
            return $response;
        }
        
        
    }
    
    private function getTestData()
    {
        $data = array(
            'onlyNative' => true,
            'forcedStart' => false,
            'payBlock' => true,
            'onlyGoods' => false,
            'hidezones' => ['.informerTop', '#tenDaysSpread', '#MarketGidComposite628632', '#right-slot2', '#right-slot3', '#div-gpt-ad-1512480795697-0'],
            //'hidezones' => [],
            'stophide' => ['alpha', 'bravo', 'charlie'],
            'providers' => ['fwdcdn.com', 'trafmag.com', 'an.yandex.ru', 'mixadvert.com', 'adriver.ru', 'doubleclick.net', 'yottos.com', 'adpartner.pro', 'mediainform.net'],
            'slots' => [
                array('disabled' => false, 'id' => 1, 'name' => '1', 'zones' => ['5000001', '5000003'], 'comment' => 'Коммент1', 'n'=>array('selector'=> '.sersers', 'parent'=> 3, 'next'=> 5), 'o'=>array('top'=> 1, 'right'=> 2, 'bottom'=> 3,'left'=> 4), 'm'=>'right', 'ha'=>'center', 'sh'=>true, 'f'=>array('topOffset'=>2, 'bottomSync'=>'top', 'node'=>array('selector'=>'.asd-1')), 's'=>array('margin'=>'10px;', 'position'=>'fixed')),
                array('disabled' => true, 'id' => 2, 'name' => '2', 'zones' => ['5000001', '5000002'], 'f'=>array('bottomSync'=>'bottom', 'node'=>array('selector'=>'.asd-1'))),
            ],
            'zones' => [
                array(
                    'disabled' => false, 'id' => '5000001', 'name' => '5000001',
                    'styles' => 'margin-bottom:15px',
                    'width' => 200 , 'height' => 400,
                    'codes' => ['__rtb__'],
                    'selectors' => ['#div-gpt-ad-1', '#div-gpt-ad-2'],
                    'more_selectors' => ['#span-gpt-ad-1', '#span-gpt-ad-2'],
                    'targets' => ['#right-slot6'],
                    'addition' => [
                        array(
                            'b'=> array('name_11'=>'value_11', 'name_12'=>'value_12'),
                            'e'=> array('name_21'=>'value_21', 'name_22'=>'value_22', 'name_23'=>'value_23'),
                        ),
                    ],
                    'comment' => 'Коммент1'
                ),
                array('disabled' => false, 'id' => '5000002', 'name' => '5000002', 'styles' => 'margin-bottom:15px', 'comment' => 'Коммент2', 'width' => 200 , 'height' => 400, 'targets' => ['selector-0']),
                array('disabled' => true, 'id' => '5000003', 'name' => '5000003', 'styles' => 'margin-bottom:15px',  'width' => 200 , 'height' => 400),
            ],
            'codes' => [
                array('id' => 563, 'title' => 'right_1', 'provider' => 'trafmag', 'code' => '<div id="trafmag_0d6b2b4d"></div>'),
                array('id' => 564, 'title' => 'center_1', 'provider' => 'adpartner', 'code' => '<<div id="adpartner-vunit-407">'),
            ],
            
            'allProviders' => ['admixer', 'adpartner', 'custom', 'trafmag', 'yottos']
        );
        
        
        $response = new JsonResponse($data);
        return $response;
    }

}