$(document).ready(function () {
    "use strict";
    
    Number.prototype.formatMoney = function(c, d, t){
        var n = this, 
            c = isNaN(c = Math.abs(c)) ? 2 : c, 
            d = d == undefined ? "." : d, 
            t = t == undefined ? "," : t, 
            s = n < 0 ? "-" : "", 
            i = String(parseInt(n = Math.abs(Number(n) || 0).toFixed(c))), 
            j = (j = i.length) > 3 ? j % 3 : 0;
        return s + (j ? i.substr(0, j) + t : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + t) + (c ? d + Math.abs(n - i).toFixed(c).slice(2) : "");
    };

    // Исхдные данные в таблице сайтов:
    var
        sumTraffic = 0,
        dataSites = [],
        $sitesRows = $('table.table-striped tbody tr'),
        $dataColumns;
    
    // Запрос данных о доходе за вчера:
    var action = $('.btn-toolbar .btn-primary').attr('href');
    
    $.ajax(action, {
        type: 'POST',           
        data: {yesterdayStat: true},           
        success: function(data) {
            //console.log('AAA success: ', data);
            if (data) {
                $sitesRows.each(function(){
                    var $this = $(this);
                    if (data[$this.data('site')]) {
                        $('td.money', $this).html(data[$this.data('site')].formatMoney(2));
                    }
                });
                AddDataSites();
            }
        },
        error: function(ajaxObj, textStatus, textError) {
            //console.log('AAA error');
        }
    });
    
    AddDataSites();
    
    // Клик по названию колонки для сортировки:
    Array.prototype.forEach.call(document.querySelectorAll(".sort[data-sort]"), function (el) {
        $(el).on("click", function (e) {
            // Сортировка в таблице
            var sortField = $(this).data('sort');
            var sortAsc = $(this).attr('data-sortasc');
            $(this).attr('data-sortasc', -sortAsc);
            
            //console.log('AAA sortAsc = ', sortAsc);
            
            dataSites.sort(function(a, b) {
                if (sortAsc < 0) {
                    return (a[sortField] > b[sortField]) ? 1 : -1;
                } else {
                    return (a[sortField] < b[sortField]) ? 1 : -1;
                }
            });
            
            // Переписываем таблицу:
            var 
                $table = $('#table-site'),
                $tableContent = $('<tbody>'),
                $tableBody = $table.find('tbody').first();
            
            for (var i = 0; i < dataSites.length; i++) {
                var $row;
                $row = $('<tr data-site="' + dataSites[i].domain + '">').html(dataSites[i].tr);
                if (!dataSites[i].isVisible) {
                    $row.hide();
                }
                $row.appendTo($tableContent);
            }
            $tableBody.html('').append($tableContent.children());
            
        });
    });
    
    // Клик на галочку "Сайт включен":
    $('#table-site').on('change', 'input.is-enabled', function(e) {
        
        var
            $this = $(this),
            siteId = $this.parents('tr').data('id'),
            $siteTr = $this.parents('tr'),
            isEnabled = $this.prop( "checked" ),
            action = $this.parents('table').data('action') + siteId,
            method = 'POST',
            data = {
                'toggle_enabled': 1,
                'is_enabled': isEnabled ? 1 : 0,
            };
        
        $this.prop("disabled", true);
        
        $.ajax(action, {
            type: method,
            data: data,
            success: function(data) {
                $this.prop("disabled", false);
                
                if (data.result) {
                    if (isEnabled) {
                        $siteTr.removeClass('disabled');
                    } else {
                        $siteTr.addClass('disabled');
                    }
                }
            },
            error: function(rew, status, err) {
                console.log(status, err);
                $this.prop("disabled", false);
            }
        });
        return false;
    });
    
    // Клик на кнопку статистики:
    /*
    Array.prototype.forEach.call(document.querySelectorAll("button[data-link]"), function (el) {
        $(el).on("click", function (e) {
            e.stopPropagation();
            document.location.href = this.getAttribute("data-link");
        });
    });
    */
    
    // Выбор даты для BidStat http://t1m0n.name/air-datepicker/docs/index-ru.html
    var nowDate = new Date();
    
    $('#date-value').datepicker({
        dateFormat: "yyyy-mm-dd",
        autoClose: true,
        range: true,
        maxDate: nowDate,
        onHide: function(dp, animationCompleted){
            if (animationCompleted) {
                selectSitesWithSelectedData(dp);
            }
        }
    }).data('datepicker');
   
    function selectSitesWithSelectedData(data)
    {
        var
            selectInterval = (data.selectedDates.length > 1),
            selectNoDate = (data.selectedDates.length == 0);
        
        $sitesRows = $('table.table-striped tbody tr');
        $sitesRows.each(function(i, e){
            $dataColumns = $('td', $(e));
            
            var
                siteDateCreate = $.trim($('.site-create-date', $dataColumns[4]).text()),
                dateSite = (new Date(siteDateCreate + ' 00:00')).getTime();
            
            if (selectNoDate) {
                $(this).show();
            } else if (selectInterval) {
                var
                    dateFrom = (new Date(data.selectedDates[0])).getTime(),
                    dateTo = (new Date(data.selectedDates[1])).getTime();
                    
                if (dateSite>=dateFrom && dateSite<=dateTo) {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            } else {
                var dateSelect = (new Date(data.selectedDates[0])).getTime();
                
                if (dateSite==dateSelect) {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            }
        });
        
        AddDataSites();
    }
    
    // Формирование данных о сайтах из таблицы
    function AddDataSites()
    {
        var
            $siteRow;
            //siteTraffic;
        
        //sumTraffic = 0;
        dataSites = [];
        $sitesRows.each(function(i, e){
            $siteRow = $(e);
            dataSites.push({
                tr: $(e).html().replace(/\s{2,}/g, ' '),
                id: $.trim($('.site-id', $siteRow).text()),
                domain: $.trim($('.site-domain a', $siteRow).text()),
                user: $.trim($('.user-name a', $siteRow).text()),
                date: $.trim($('.site-create-date', $siteRow).text()),
                //traffic: ($.trim($('.site-traffic', $siteRow).data('traffic')) !="") ? parseInt($.trim($('.site-traffic', $siteRow).data('traffic'))) : 0,
                isVisible: $(e).is(':visible'),
                money: ($.trim($('.money', $siteRow).html()) !="") ? parseFloat($.trim($('.money', $siteRow).html())) : 0,
            });

            /*
            siteTraffic = $.trim($('.site-traffic', $siteRow).data('traffic'));
            siteTraffic = (siteTraffic != '') ? siteTraffic : 0;
            sumTraffic += ($siteRow.is(':visible')) ? parseInt(siteTraffic) : 0;
            */

        });
        
        
        // Прописываем суммарный траффик по выбранным сайтам:
        /*
        sumTraffic = sumTraffic.formatMoney(0);
        $('.sum-traffic span').text(sumTraffic);
        */
    }
    
});