$(document).ready(function () {
    
    // Дата создания сайта
    $('#site-date-create').datepicker({
        format: 'yyyy-mm-dd',
        language: $('#site-date-create').data('language')
    });
    
    /*
    if($('#sites-categories').val()) {
        var categoriesList = JSON.parse($('#sites-categories').val());
    }
    */
   
    // Переключение данных форм для отображения (sale-marker)
    $('.switch-item').on('click', function(){
        var
            $this = $(this),
            type = $this.data('type'),
            classSelected = 'selected';
           
        $('.switch-item').removeClass(classSelected);
        $this.addClass(classSelected);
        
        $('.form-group-data').removeClass(classSelected);
        $('.form-group-data.'+type).addClass(classSelected);
    });

    // Список алиасов
    $('#site-alias').tokenfield();

    // Обработка списков значений:
    (function(){

        // Выбор пункта в select:
        // Дописать логику смены состояния checked

        // Клик на "Редактировать" для показа списка значений вместо строки:
        $('.form-group-data').on('click', '.edit-item', function(){
            var
                $this = $(this),
                $wrap = $this.parents('.form-group')[0],
                $valuesString = $('.values-string', $wrap),
                $valuesEdit = $('.values-edit', $wrap),
                $valuesItems = $('.values-items', $wrap),
                $tempState = $('.temp-state', $wrap);

            $tempState.empty();
            $tempState.html($valuesItems.html());

            CheckNoValues($this);
            $this.hide();
            $valuesString.hide();
            $valuesEdit.show();
            return false;
        });

        // Клик на "Добавить" значение в список:
        $('.form-group-data').on('click', '.add-item', function(){
            var
                $wrap = $(this).parents('.form-group').first(),
                $valuesItems = $('.values-items', $wrap),
                $tplInput;

            if ($wrap.hasClass('hidezones')) {
                $tplInput = $('.input-pattern .input-item').clone();
            }
            if ($wrap.hasClass('stophide')) {
                $tplInput = $('.input-pattern .input-item').clone();
            }
            if ($wrap.hasClass('selectors')) {
                $tplInput = $('.input-pattern .input-item').clone();
            }
            if ($wrap.hasClass('more_selectors')) {
                $tplInput = $('.input-pattern .input-item').clone();
            }
            if ($wrap.hasClass('providers')) {
                $tplInput = $('.providers-pattern .input-item').clone();
            }
            if ($wrap.hasClass('codes_id')) {
                $tplInput = $('.zone-pattern .input-item').clone();
            }
            if ($wrap.hasClass('zones_id')) {
                $tplInput = $('.slot-pattern .input-item').clone();
            }

            $valuesItems.append($tplInput);
            CheckNoValues($(this));
            return false;
        });

        // Клик на "Удалить" значение из списка:
        $('.form-group-data').on('click', '.delete-input', function(){
            var
                $wrap = $(this).parents('.input-item'),
                $items = $(this).parents('.values-items');
            
            $wrap.remove();
            CheckNoValues($items);
            return false;
        });

        // Клик на "Отмена" показа списка:
        $('.form-group-data').on('click', '.cancel-item', function(){
            var
                $wrap = $(this).parents('.form-group').first(),
                $edit = $('.edit-item', $wrap),
                $valuesString = $('.values-string', $wrap),
                $valuesEdit = $('.values-edit', $wrap),
                $valuesItems = $('.values-items', $wrap),
                $tempState = $('.temp-state', $wrap);

            $valuesItems.html($tempState.html());

            $tempState.empty();
            $edit.show();
            $valuesString.show();
            $valuesEdit.hide();
            return false;
        });

        // Клик на "Сохранить" список значений:
        $('.form-group-data').on('click', '.save-item', function(){
            var
                $wrap = $(this).parents('.form-group').first(),
                $edit = $('.edit-item', $wrap),
                $valuesString = $('.values-string', $wrap),
                $valuesEdit = $('.values-edit', $wrap),
                $valuesItems = $('.values-items .input-item', $wrap),
                $tempState = $('.temp-state', $wrap),
                dataItems = [];

            markerDataIsChanged = true;

            $valuesItems.each(function(){
                var
                    $this = $(this),
                    itemValue;

                if ($('select', $this).length) {
                    itemValue = $('select', $this).val();
                    if (itemValue == 'other') {
                        itemValue =  $.trim($('input', $this).val());
                        $('input', $this).attr("value", itemValue);
                    }
                } else {
                    itemValue =  $.trim($('input', $this).val());
                    $('input', $this).attr("value", itemValue);
                }

                if (itemValue) {
                    dataItems.push(itemValue);
                }
            });

            $valuesString.empty();
            dataItems.forEach(function(item){
                $valuesString.append('<span>' + item + '</span> ');
            });

            if ($wrap.hasClass('codes_id')) {
                var $infoCodes = $('.zone-info .codes-titles', $wrap.parents('.zone-item'));
                $infoCodes.empty();
                $infoCodes.html(dataItems.join(', '));
            }

            $tempState.empty();
            $edit.show();
            $valuesString.show();
            $valuesEdit.hide();
            return false;
        });

        function CheckNoValues($this)
        {
            var
                $wrap = $('.values-edit', $this.parents('.form-group')[0]),
                $inputItems = $('.values-items .input-item', $wrap),
                $noValues = $('.no-values', $wrap);
            
            if ($inputItems.length) {
                $noValues.hide();
            } else {
                $noValues.show();
            }
        }

    })();
    
    // Владелец сайта и другие пользователи, которым доступен сайт:
    (function(){
        
        var
            $inputAccessUser = $('#site-access-user'),
            delimiterAccessUser = ';';
        
        $inputAccessUser.tokenfield({delimiter: delimiterAccessUser, beautify: false});
        
        // Изменение владельца сайта
        $('select.site-user').on('change', function() {
            var
                optionSelected = $("option:selected", this),
                selectedUser = optionSelected.text().trim(),
                dataAccessUsers = $inputAccessUser.tokenfield('getTokensList').split(delimiterAccessUser);

            if (dataAccessUsers.indexOf(selectedUser) > -1)
            {
                alert('Данный пользователь в списке пользователей, которым доступен сайт!');
                $(this).val(0);
            }
        });    
        
        // Добавление пользователя:
        $('.add-access-user').click(function(){
            var
                addUser = $('select.access-user').val(),
                listAddUsers = $inputAccessUser.tokenfield('getTokensList'),
                dataAddUsers = listAddUsers.split(delimiterAccessUser),
                siteUser = $('select.site-user option:selected').text().trim();

            if (!addUser) {
                return false;
            }

            if (addUser == siteUser)
            {
                alert('Выбранный пользователь уже указан как владелец сайта!');
            }
            else if (dataAddUsers.indexOf(addUser) > -1)
            {
                alert('Выбранный пользователь уже присутствует в списке!');
            }
            else
            {
                $inputAccessUser.tokenfield('setTokens', listAddUsers + delimiterAccessUser + addUser);
            }

            return false;
        });
        
    })();
   
    // Категории
    (function(){
        
        // Добавление категории
        $('.btn.add-category').on('click', function(){
            var $categoryItems = $('.categories .category-item');

            if ($categoryItems.length < 3)
            {
                // Добавляем новую категорию
                var $categoryBlock = $('.category-pattern .category-item').clone();
                $('.categories').append($categoryBlock);
                setCategories();
            }
            return false;
        });

        // Удаление категории
        $('.categories').on('click', '.delete-category', function() {
            var $wrap = $(this).parents('.category-item');
            $wrap.remove();
            setCategories();
        });
        
        function setCategories()
        {
            var $categoryItems = $('.categories .category-item');

            $categoryItems.each(function(i){
                var
                    $this = $(this),
                    $label = $('.for-category', $this),
                    $select = $('.form-control', $this),
                    $delete = $('.delete-category', $this);

                $label.text('Категория ' + (i+1));
                $label.attr('for', 'category' + (i+1));
                $select.attr('id', 'site-category' + (i+1));
                $select.attr('name', 'category' + (i+1));

                if ($categoryItems.length>1) {
                    $delete.show();
                } else {
                    $delete.hide();
                }
            });
        }
        
    })();
    
    // Server Data
    (function(){
        
        var
            //$provConfTemplate = $('.prov-conf-pattern .prov-conf-field-item'),
            //$provConfPlace = $('.b-filters_serverdata.dsp .prov-conf'),
            classHidden = 'is-hidden';
        
        // Изменение активности зоны
        $('#is-server-data').on('change', function(e){
            var
                isActive = $(this).is(':checked'),
                $wrap = $(this).parent(),
                $serverdataInner = $('.serverdata-inner', $wrap);
                
            if (!isActive) {
                $serverdataInner.addClass(classHidden);
            } else {
                $serverdataInner.removeClass(classHidden);
            }
        });
        
        // Добавить значение prov-conf
        /*
        $('.add-prov-conf').on('click', function(e){
            $provConfPlace.append($provConfTemplate.clone());
        });
        */
       
        // Удалить значение prov-conf
        /*
        $provConfPlace.on('click', '.delete-prov-conf-field', function(e){
            $(this).parent().remove();
        });
        */
        
    })();
    
    // Providers
    (function(){
    
        // Выбор targets:
        $('.form-group.providers').on('change', 'select', function(e){
            var
                targets = this.value,
                $wrap = $(this).parents('.input-item'),
                $valueProviders = $('input.providers', $wrap);
                
            if (targets != 'other') {
                $valueProviders.hide();
            } else {
                $valueProviders.show();
            }
        });
        
    })();
   
    // Zones
    (function(){
        
        // Определяем наибольший id зоны:
        var lastIdZone = $('.zones').data('zones-current-id');
        
        // Инициализация имеющихся блоков зон:
        setZones();
        
        // Разворачивание-сворачивание инфы зоны
        $('.zones').on('click', '.show-zone', function(){
            var $zoneItem = $(this).parents('.zone-item');
            $zoneItem.toggleClass('open');
        });

        // Добавление зоны
        $('.btn.add-zone').on('click', function(){
            // Добавляем новую зону
            var $zoneBlock = $('.zone-pattern .zone-item').clone();
            $('.zones').append($zoneBlock);
            setZones();
            return false;
        });

        // Удаление зоны
        $('.zones').on('click', '.delete-zone', function() {
            var
                $wrap = $(this).parents('.zone-item'),
                zoneId = $('.for-zone', $wrap).data('id');
            $wrap.remove();
            DeleteZoneFromList(zoneId)
        });

        // Выбор размера зоны:
        $('.zones').on('change', '.form-control.size', function(e){
            var
                size = this.value.split('x'),
                width = size[0],
                height = size[1],
                $wrap = $(this).parents('.zone-item'),
                $valueSizes = $('.other-size', $wrap),
                $infoValueSizes = $('.zone-info .size', $wrap);

            if (size != 'other') {
                $valueSizes.hide();
                $('.form-control.width', $valueSizes).val(width);
                $('.form-control.height', $valueSizes).val(height);
                $infoValueSizes.text(width + ' X ' + height);
            } else {
                $valueSizes.show();
                $('.form-control.width', $valueSizes).val('');
                $('.form-control.height', $valueSizes).val('');
            }
        });
        
        // Выбор размера зоны (другой...):
        $('.zones').on('change', '.form-control.width, .form-control.height', function(e){
            var
                $wrap = $(this).parents('.zone-item'),
                width = $('.zone-content .size input.width', $wrap).val(),
                height = $('.zone-content .size input.height', $wrap).val(),
                $infoValueSizes = $('.zone-info .size', $wrap);
            $infoValueSizes.text(width + ' X ' + height);
        });

        // Изменение активности зоны
        $('.zones').on('change', '.is-hidden input', function(e){
            var
                isActive = $(this).is(':checked'),
                $wrap = $(this).parents('.zone-item'),
                classHidden = 'is-hidden';
                
            if (!isActive) {
                $wrap.addClass(classHidden);
            } else {
                $wrap.removeClass(classHidden);
            }
        });

        // Показ-скрытие дополнительных полей addition:
        $('.zones').on('change', 'input.addition', function(e){
            var
                $this = $(this),
                isChecked = $this.is(':checked'),
                $additionFields = $('.addition-fields', $this.parent());

            if (isChecked) {
                $additionFields.show();
            } else {
                $additionFields.hide();
            }
        });

        // Добавление группы дополнительных полей:
        $('.zones').on('click', '.addition-add', function(e){
            var $additionBlock = $('.zone-pattern .addition-block-item').clone();
            $additionBlock.insertBefore($(this));
        });

        // Удаление группы дополнительных полей:
        $('.zones').on('click', '.delete-addition-block', function() {
            var $wrap = $(this).parents('.addition-block-item');
            $wrap.remove();
        });

        // Добавление поля данных дополнительных полей:
        $('.zones').on('click', '.addition-add-field', function(e){
            var $fieldBlock = $('.zone-pattern .addition-field-item').clone();
            $fieldBlock.insertBefore($(this));
        });

        // Удаление поля данных дополнительных полей:
        $('.zones').on('click', '.delete-addition-field', function() {
            var $wrap = $(this).parents('.addition-field-item');
            $wrap.remove();
        });
        
        // Выбор targets:
        $('.zones').on('change', 'select.form-control.targets', function(e){
            var
                targets = this.value,
                $wrap = $(this).parents('.targets'),
                $valueTargets = $('input.targets', $wrap);

            if (targets != 'other') {
                $valueTargets.hide();
            } else {
                $valueTargets.show();
            }
        });
        
        // Показ-скрытие полей данных min-cpm:
        $('.zones').on('change', 'input.min-cpm', function(e){
            var
                $this = $(this),
                isChecked = $this.is(':checked'),
                $minCpmFields = $('.min-cpm-fields', $this.parent());

            if (isChecked) {
                $minCpmFields.show();
            } else {
                $minCpmFields.hide();
            }
        });
        
        function setZones()
        {
            // Проставляем нумерацию зон:
            $('.zones .zone-item .for-zone[data-id=""]').each(function(){
                var
                    $this = $(this),
                    zoneId,
                    lastNumber = 0;

                $('.zones .zone-item .for-zone').each(function(){
                    var idZone = +$(this).attr('data-id');
                    lastNumber = (idZone && idZone > lastNumber) ? idZone : lastNumber;
                });

                zoneId = (lastNumber > lastIdZone) ? lastNumber+1 : lastIdZone+1;

                $this.text(zoneId);
                $this.attr('data-id', zoneId);
                AddZoneIntoList(zoneId);
            });
        }
        
        function AddZoneIntoList(id)
        {
            // Добавляем название кода в списки параметров zone_id внутри слотов:
            $('.slots .slot-item').each(function(){
                var
                    $selectControl = $('.form-group.zones_id .form-control', $(this)),
                    $optionItem = $('<option value="' + id + '" >' + id + '</option>');
                $selectControl.append($optionItem);
            });

            // Добавляем название кода в списки параметров внутри шаблона слота:
            var
                $selectControlTemplateCode = $('.slot-pattern .input-item .form-control'),
                $optionItem = $('<option value="' + id + '" >' + id + '</option>');
            $selectControlTemplateCode.append($optionItem);
        }
        
        function DeleteZoneFromList(id)
        {
            $('.slots .slot-item').each(function(){
                var
                    $slotItem = $(this),
                    $selectedZones = $('.form-group.zones_id .form-control', $slotItem);
                $selectedZones.each(function(){
                    if ($(this).val() == id) {
                        console.log('AAA lll = ', $('.form-group.zones_id .form-control', $slotItem).length);
                        $(this).parents('.input-item').remove();
                    }
                });
                $('.form-group.zones_id .form-control option[value="' + id + '"]', $(this)).remove();
            });
            $('.slot-pattern .input-item .form-control option[value="' + id + '"]').remove();
        }
        
    })();
   
    // Codes
    (function(){
        
        // Разворачивание-сворачивание инфы кода
        $('.codes').on('click', '.show-code', function(){
            var $codeItem = $(this).parents('.code-item');
            $codeItem.toggleClass('open');
            
        });
        
        // Добавление кода
        $('.btn.add-code').on('click', function(){
            // Добавляем новый код
            var $codeBlock = $('.code-pattern .code-item').clone();
            $('.codes').append($codeBlock);
            setCodes();
            markerDataIsChanged = true;
            return false;
        });

        // Удаление кода
        $('.codes').on('click', '.delete-code', function() {
            var
                $wrap = $(this).parents('.code-item'),
                title = $('.form-control.title', $wrap).val();
            
            // Удаляем значение кода из списков:
            DeleteCodeFromList(title);
            $wrap.remove();
            setCodes();
            markerDataIsChanged = true;
        });
        
        // Изменение названия
        $('.codes').on('change', 'input.form-control.title', function(e){
            var
                title = $.trim(this.value),
                $this = $(this),
                $wrap = $this.parents('.code-item'),
                $infoTitle = $('.code-info .title', $wrap),
                codeName = $('label.for-code', $wrap).data('name');
            
            // Обновляем значение поля без пробелов:
            $this.val(title);
            
            // Проверка на уже зарегистрированный title кода:
            var
                isAlreadyExist = false,
                $itemWrap = $(this).parents('.code-item');
            
            $('.codes .code-item').not($itemWrap).each(function(){
                var itemTitle = $('.form-control.title', $(this)).val();
                if (itemTitle == title) {
                    isAlreadyExist = true;
                }
            });
            
            if (isAlreadyExist) {
                alert('Код с таким названием уже присутствует в списке!');
                $this.focus().val('');
            } else {
                $infoTitle.text(title);
                // Добавление кода в списки:
                AddCodeIntoList(codeName, title);
            }

        });
        
        // Выбор provider:
        $('.codes').on('change', 'select.form-control.provider', function(e){
            var
                targets = this.value,
                $wrap = $(this).parent(),
                $valueProvider = $('input.provider-other', $wrap);
                

            if (targets != 'other') {
                $valueProvider.hide();
            } else {
                $valueProvider.show();
            }
        });
        
        function AddCodeIntoList(name, title)
        {
            /*
            // Удаляем предыдущие значения кода:
            $('.zones .zone-item').each(function(){
                $('.form-group.codes_id .form-control option[data-name="' + name + '"]', $(this)).remove();
            });
            $('.zone-pattern .input-item .form-control option[data-name="' + name + '"]').remove();
            */
            
            // Добавляем название кода в списки параметров code_id внутри зоны:
            $('.zones .zone-item').each(function(){
                var
                    $selectControl = $('.form-group.codes_id .form-control', $(this)),
                    $rtbOption = $('option[value="RTB"]', $selectControl),
                    $optionItem = $('<option data-id="' + name + '" value="' + title + '" >' + title + '</option>');
                $optionItem.insertBefore($rtbOption);
            });

            // Добавляем название кода в списки параметров внутри шаблона кода:
            var
                $selectControlTemplateCode = $('.zone-pattern .input-item .form-control'),
                $rtbOption = $('option[value="RTB"]', $selectControlTemplateCode),
                $optionItem = $('<option data-id="' + name + '" value="' + title + '" >' + title + '</option>');
            $optionItem.insertBefore($rtbOption);
        }
        
        function DeleteCodeFromList(title)
        {
            $('.zones .zone-item').each(function(){
                $('.form-group.codes_id .form-control option[value="' + title + '"]', $(this)).remove();
            });
            $('.zone-pattern .input-item .form-control option[value="' + title + '"]').remove();
        }
        
        function setCodes()
        {
            var $codeItems = $('.codes .code-item');

            $codeItems.each(function(i){
                var
                    $this = $(this),
                    $label = $('.for-code', $this);

                $label.text(i+1);
                $label.attr('data-name', i+1);
            });
        }
        
    })();

    // Slots
    (function(){
        
        // Разворачивание-сворачивание инфы слота
        $('.slots').on('click', '.show-slot', function(){
            var $slotItem = $(this).parents('.slot-item');
            $slotItem.toggleClass('open');
        });
        
        // Добавление слота
        $('.btn.add-slot').on('click', function(){
            // Добавляем новый код
            var $slotBlock = $('.slot-pattern .slot-item').clone();
            $('.slots').append($slotBlock);
            setSlots();
            markerDataIsChanged = true;
            return false;
        });

        // Удаление слота
        $('.slots').on('click', '.delete-slot', function() {
            var
                $wrap = $(this).parents('.slot-item');
            
            // Удаляем значение кода из списков:
            $wrap.remove();
            setSlots();
            markerDataIsChanged = true;
        });
        
        // Изменение активности слота
        $('.slots').on('change', '.is-hidden input', function(e){
            var
                isActive = $(this).is(':checked'),
                $wrap = $(this).parents('.slot-item'),
                classHidden = 'is-hidden';
                
            if (!isActive) {
                $wrap.addClass(classHidden);
            } else {
                $wrap.removeClass(classHidden);
            }
        });
        
        // Изменение списка зон для info-title
        $('.slots').on('click', '.form-group.zones_id .save-item', function(e){
            var
                $this = $(this),
                $wrap = $this.parents('.slot-item'),
                $infoTitle = $('.slot-info .title', $wrap),
                $zonesItems = $('.form-group.zones_id .values-items .form-control', $wrap),
                zonesId = [],
                title;
                
                $zonesItems.each(function(){
                    zonesId.push($(this).val());
                });
                title = zonesId.join(', ');
            
            $infoTitle.text(title);
        });
        
        // Добавление поля данных styles:
        $('.slots').on('click', '.add-styles', function(e){
            var $fieldBlock = $('.slot-pattern .styles-field-item').clone();
            $fieldBlock.insertBefore($(this));
            markerDataIsChanged = true;
        });

        // Удаление поля данных styles:
        $('.slots').on('click', '.delete-styles-field', function() {
            var $wrap = $(this).parents('.styles-field-item');
            $wrap.remove();
            markerDataIsChanged = true;
        });
        
        // Сворачивание-разворачивание fixed:
        $('.slots').on('change', '.is-fixed', function() {
            var
                $wrap = $(this).parents('.fixed'),
                $fixedContent = $('.fixed-content', $wrap);

            if ($(this).is(':checked')) {
                $fixedContent.show();
            } else {
                $fixedContent.hide();
            }
        });
        
        // Показ "Синхронизировать высоту":
        $('.slots').on('change', '.form-control.slot-margin', function() {
            var
                $this = $(this),
                $syncHeight = $('.syncHeight-inner', $this.parents('.slot-item'));

            if (['left','right'].indexOf($(this).val())<0) {
                $syncHeight.hide();
            } else {
                $syncHeight.show();
            }
        });
        
        // Сворачивание-разворачивание addStyles:
        $('.slots').on('change', '.is-addStyles', function() {
            var
                $wrap = $(this).parents('.addStyles');

            if ($(this).is(':checked')) {
                $wrap.removeClass('disabled');
            } else {
                $wrap.addClass('disabled');
            }
        });
        
        // Добавление поля данных addStyles:
        $('.slots').on('click', '.add-addStyles', function(e){
            var $addStylesBlock = $('.slot-pattern .addStyles-item').clone();
            $addStylesBlock.insertBefore($(this));
            markerDataIsChanged = true;
        });
        
        // Удаление поля данных addStyles:
        $('.slots').on('click', '.delete-addStyles-item', function() {
            var $wrap = $(this).parents('.addStyles-item');
            $wrap.remove();
            markerDataIsChanged = true;
        });
        
        // Добавление поля данных addStyles-rules:
        $('.slots').on('click', '.add-addStyles-rules', function(e){
            var
                $wrap = $(this).parents('.addStyles-item'),
                $addStylesRulesBlock = $('.slot-pattern .addStyles-rules-item').clone();
            $wrap.append($addStylesRulesBlock);
            markerDataIsChanged = true;
        });
        
        // Удаление поля данных addStyles-rules:
        $('.slots').on('click', '.delete-addStyles-rules-item', function() {
            var $wrap = $(this).parents('.addStyles-rules-item');
            $wrap.remove();
            markerDataIsChanged = true;
        });
        
        function setSlots()
        {
            var $slotItems = $('.slots .slot-item');

            $slotItems.each(function(i){
                var
                    $this = $(this),
                    $label = $('.for-slot', $this);

                $label.text(i+1);
                $label.attr('data-name', i+1);
            });
        }

    })();

    // Изменения в тех данных:
    var
        $markerGroupForm = $('.form-group-data.marker'),
        markerDataIsChanged = false;
    $('input, select, textarea', $markerGroupForm).change(function(){
       markerDataIsChanged = true;
    });

    // Клик на "Сохранить Опубликовать Откат":
    var busy = false;
    $('.btn.btn-primary.submit-action').on('click', function(){
        
        var
            actionType = $(this).data('type'),
            warningInfo;
        
        if (actionType == 'publish') {
             if (!confirm("Опубликовать данные?")) return false;
        }
        if (actionType == 'cancel-draft') {
            if (!confirm("Очистить черновик с данными?")) return false;
        }
       
        if(busy) {
            return false;
        }
        
        var
            $form = $('#site-form'),
            action = $form.attr('action'),
            method = $form.attr('method');
        
        // Данные для отправки в запросе:
        var data = {};
        
        if (actionType == 'cancel-draft') {
            data['cancel_draft'] = 1;
        } else {
            
            // Включен ли сайт:
            data['enabled'] = ($('#site-enable').is(':checked')) ? 1 : 0;

            // Формируем данные о сервисных параметрах:
            data['only_native'] = ($('#only_native').is(':checked')) ? 1 : 0;
            data['forced_start'] = ($('#forced_start').is(':checked')) ? 1 : 0;
            data['pay_block'] = ($('#pay_block').is(':checked')) ? 1 : 0;
            data['only_goods'] = ($('#only_goods').is(':checked')) ? 1 : 0;

            // Формируем данные serverdata:
            if ($('input#is-server-data').is(':checked')) {
                var
                    serverData = {
                        'ssp_conf': {},
                        'dsp_conf': {},
                    },
                    sspProvidersFieldName = ($('input#ssp-exclude').is(':checked')) ? 'provider_blacklist' : 'provider_whitelist',
                    dspProvidersFieldName = ($('input#dsp-exclude').is(':checked')) ? 'provider_blacklist' : 'provider_whitelist',
                    sspProvidersList = [],
                    dspProvidersList = [],
                    $groupServerdata = $('.form-group.serverdata'),
                    $provConfItems = $('.prov-conf-field-item', $groupServerdata);
                    
                    $('.ssp-list input', $groupServerdata).each(function(){
                        var $this = $(this);
                        if ($this.is(':checked')) {
                            sspProvidersList.push($this.data('id'))
                        }
                    });
                    serverData['ssp_conf'][sspProvidersFieldName] = sspProvidersList;
                    
                    $('.dsp-list input', $groupServerdata).each(function(){
                        var $this = $(this);
                        if ($this.is(':checked')) {
                            dspProvidersList.push($this.data('id'))
                        }
                    });
                    serverData['dsp_conf'][dspProvidersFieldName] = dspProvidersList;
                
                    if ($provConfItems.length>0) {
                        var provConf = {};
                        $provConfItems.each(function(){
                            var $this = $(this);
                            //provConf[$('.provider', $this).val()] = $('.config', $this).val()
                            provConf[$('.provider', $this).text()] = $('.config', $this).val()
                        });
                        serverData['dsp_conf']['prov_conf'] = provConf;
                    }
                
                data['server_data'] = serverData;
            } else {
                data['server_data'] = null;
            }

            // Формируем данные hidezones:
            var
                dataHidezones = [],
                $hidezoneItems = $('.form-group.hidezones .values-string span');

            $hidezoneItems.each(function(){
                dataHidezones.push($(this).text());
            });
            $('input#hidezones').val(JSON.stringify(dataHidezones));

            // Формируем данные stophide:
            var
                dataStophide = [],
                $stophideItems = $('.form-group.stophide .values-string span');

            $stophideItems.each(function(){
                dataStophide.push($(this).text());
            });
            $('input#stophide').val(JSON.stringify(dataStophide));

            // Формируем данные providers:
            var
                dataProviders = [],
                $providersItems = $('.form-group.providers .values-string span');

            $providersItems.each(function(){
                dataProviders.push($(this).text());
            });
            $('input#providers').val(JSON.stringify(dataProviders));

            // Формируем данные zones:
            var
                dataZones = [],
                $zoneItems = $('.zones .zone-item');

            $zoneItems.each(function(){
                var
                    $this = $(this),
                    dataSelectors = [],
                    dataMoreSelectors = [],
                    $selectorsItems = $('.form-group.selectors .values-string span', $this),
                    $moreSelectorsItems = $('.form-group.more_selectors .values-string span', $this),
                    dataAddition = [],
                    $additionItems = $('.addition-data .addition-block-item', $this),
                    dataMinCpm = null,
                    $minCpmCheck = $('input.min-cpm', $this);

                $selectorsItems.each(function(){
                    dataSelectors.push($(this).text());
                });

                $moreSelectorsItems.each(function(){
                    dataMoreSelectors.push($(this).text());
                });

                $additionItems.each(function(){
                    var
                        $this = $(this),
                        dataAdditionItem = {},
                        $additionElems = $('.addition-block-elem', $this),
                        id = $this.data('id'),
                        dataItem = {
                            before: null,
                            el: null,
                            after: null,
                        };

                    $additionElems.each(function(){
                        var
                            $additionElem = $(this),
                            additionTitle = $additionElem.data('title'),
                            $additionFields = $('.addition-field-item', $additionElem);

                        if ($additionFields.length) {
                            dataItem[additionTitle] = {};
                            $additionFields.each(function(){
                                dataItem[additionTitle][$('.form-control.name', $(this)).val()] = $('.form-control.value', $(this)).val();
                            });
                        }
                    });

                    dataAdditionItem = {
                        i: id,
                        b: dataItem.before,
                        e: dataItem.el,
                        a: dataItem.after,
                    };

                    dataAddition.push(dataAdditionItem);
                });

                var targets = ($('select.form-control.targets', $this).val() != 'other') ? $('select.form-control.targets', $this).val() : $('input.form-control.targets', $this).val();

                if ($minCpmCheck.is(':checked')) {
                    var
                        valValue = $('.min-cpm-val', $this).val(),
                        curValue = $('.min-cpm-cur', $this).val();
                
                    if (valValue == '') {
                        warningInfo = 'Укажите значение min-cpm';
                    }
                    if (curValue == '') {
                        warningInfo = 'Укажите валюту в значении min-cpm';
                    }
                    
                    dataMinCpm = {
                        val: valValue,
                        cur: curValue,
                    };
                }


                dataZones.push({
                    id: $('.for-zone', $this).data('id'),
                    disabled: ($('.is_hidden', $this).is(':checked')) ? 0 : 1,
                    width: parseInt($('input.width', $this).val()),
                    height: parseInt($('input.height', $this).val()),
                    min_window_width: $('input.min-window-width', $this).val(),
                    styles: $('input.styles', $this).val(),
                    selectors: (dataSelectors.length) ? JSON.stringify(dataSelectors) : null,
                    more_selectors: (dataMoreSelectors.length) ? JSON.stringify(dataMoreSelectors) : null,
                    targets: (targets) ? JSON.stringify([targets]) : null,
                    addition: (dataAddition.length) ? JSON.stringify(dataAddition) : null,
                    min_cpm: (dataMinCpm) ? JSON.stringify(dataMinCpm) : null,
                    comment: $('.form-control.comment', $this).val(),
                });
            });
            
            $('input#zones').val(JSON.stringify(dataZones));

            // Формируем данные codes:
            var
                dataCodes = [],
                $codesItems = $('.codes .code-item');

            $codesItems.each(function(){
                var $this = $(this);
                dataCodes.push({
                    i: $('.for-code', $this).data('id'),
                    n: $('.for-code', $this).data('name'),
                    t: $('.form-control.title', $this).val(),
                    p: ($('.form-control.provider', $this).val() != 'other') ? $('.form-control.provider', $this).val() : $('.form-control.provider-other', $this).val(),
                    c: $('.form-control.code', $this).val(),
                });
            });
            $('input#codes').val(JSON.stringify(dataCodes));

            // Формируем данные codezones:
            var
                dataCodezones = [],
                dataCodezonesOpt = [],
                $codezonesItems = $('.zones .zone-item .form-group.codes_id');

            $codezonesItems.each(function(){
                var
                    codesId = [],
                    zonesId = [$('label.for-zone', $(this).parents('.zone-item')).data('id')],
                    $codesItems = $('.values-string span', $(this));

                $codesItems.each(function(){
                    var
                        codeTitle = $(this).text(),
                        codeId;

                    if (codeTitle == 'RTB') {
                        codeId = '__rtb__';
                    } else {
                        dataCodes.forEach(function(i){
                            if (i.t == codeTitle) {
                                codeId = i.n;
                                return false;
                            }
                        });
                    }
                    codesId.push(codeId);
                })

                codesId = codesId.sort();

                if (codesId.length) {
                    dataCodezones.push([codesId, zonesId]);
                }

            });

            // Оптимизируем массив, ищем одинаковые массивы с codes_id:
            dataCodezones.forEach(function(i){
                var isCommon = false;
                dataCodezonesOpt.forEach(function(j){
                    if (i[0].join(',') == j[0].join(',')) {

                        isCommon = true;
                        j[1] = j[1].concat(i[1]);
                    }
                });
                if (!isCommon) {
                    dataCodezonesOpt.push([i[0], i[1]]);
                }
            });

            data['codezones'] = JSON.stringify(dataCodezonesOpt);    

            // Формируем данные slots:
            var
                dataSlots = [],
                $slotsItems = $('.slots .slot-item');
            
            $slotsItems.each(function(){
                var
                    $this = $(this),
                    slotZones = [],
                    slotNode = {},
                    slotOffset = {},
                    slotStyles = {},
                    slotFixed = {};
                    
                var dataSlot = {
                    id: $('.for-slot', $this).data('id'),
                    name: $('.for-slot', $this).data('name'),
                    disabled: ($('.is_hidden', $this).is(':checked')) ? 0 : 1,
                }
                
                // zones
                $('.form-group.zones_id .values-string span', $this).each(function(){
                    slotZones.push(parseInt($(this).text()));
                });
                
                if (slotZones.length > 0) {
                    dataSlot['z'] = slotZones;
                }
                
                // node
                var
                    $nodeWrap = $('.form-group.node', $this),
                    selector = $.trim($('.form-control.node-selector', $nodeWrap).val()),
                    parent = $.trim($('.form-control.node-parent', $nodeWrap).val()),
                    next = $.trim($('.form-control.node-next', $nodeWrap).val());
                
                if (selector != "") slotNode['selector'] = selector;
                if (parent != "") slotNode['parent'] = parseInt(parent);
                if (next != "") slotNode['next'] = parseInt(next);
                
                if (Object.keys(slotNode).length > 0) {
                    dataSlot['n'] = slotNode;
                }
                
                // offset
                var
                    $offsetWrap = $('.form-group.offset', $this),
                    top = $.trim($('.form-control.offset-top', $offsetWrap).val()),
                    left = $.trim($('.form-control.offset-left', $offsetWrap).val()),
                    bottom = $.trim($('.form-control.offset-bottom', $offsetWrap).val()),
                    right = $.trim($('.form-control.offset-right', $offsetWrap).val());
                    
                if (top != "") slotOffset['top'] = parseInt(top);
                if (left != "") slotOffset['left'] = parseInt(left);
                if (bottom != "") slotOffset['bottom'] = parseInt(bottom);
                if (right != "") slotOffset['right'] = parseInt(right);
                
                if (Object.keys(slotOffset).length > 0) {
                    dataSlot['o'] = slotOffset;
                }
                
                // styles
                var $stylesWrap = $('.form-group.styles', $this);
                $('.styles-field-item', $stylesWrap).each(function(){
                    var
                        $fieldItem = $(this),
                        nameField = $.trim($('.form-control.name', $fieldItem).val()),
                        valueField = $.trim($('.form-control.value', $fieldItem).val());
                    if (nameField != "") slotStyles[nameField] = valueField;
                });
                
                if (Object.keys(slotStyles).length > 0) {
                    dataSlot['s'] = slotStyles;
                }
                
                // addStyles
                var $addStylesWrap = $('.form-group.addStyles', $this);
                if ($('.is-addStyles', $addStylesWrap).is(':checked')) {
                    
                    var
                        slotAddStyles = [],
                        $addStylesItems = $('.addStyles-item', $addStylesWrap);

                    $addStylesItems.each(function(){
                        var
                            $addStylesItem = $(this),
                            slotAddStylesItem = {},
                            $rulesItems = $('.addStyles-rules-item', $addStylesItem);
                        
                        slotAddStylesItem['selector'] = $.trim($('.form-control.addStyles-selector', $addStylesItem).val());
                        
                        if ($rulesItems.length>0) {
                            slotAddStylesItem['rules'] = {};
                            $rulesItems.each(function(){
                                
                                var
                                    $rulesItem = $(this),
                                    nameFieldRules = $.trim($('.form-control.name', $rulesItem).val()),
                                    valueFieldRules = $.trim($('.form-control.value', $rulesItem).val());
                                
                                if (nameFieldRules != "") {
                                    slotAddStylesItem['rules'][nameFieldRules] = valueFieldRules;
                                }
                            });
                            
                            if (Object.keys(slotAddStylesItem['rules']).length == 0) {
                                delete slotAddStylesItem['rules'];
                            }
                        }
                        
                        slotAddStyles.push(slotAddStylesItem);
                    });
                   
                    if (slotAddStyles.length > 0) {
                        dataSlot['as'] = slotAddStyles;
                    }
                }
                
                // margin
                var slotMargin = $('.form-group.margin .form-control.slot-margin', $this).val();
                if (slotMargin) {
                    dataSlot['m'] = slotMargin;
                }
                
                // syncHeight
                var slotSyncHeight = $('.form-group.syncHeight .is-syncHeight', $this).is(':checked');
                if (['left','right'].indexOf(slotMargin)>-1) {
                    dataSlot['sh'] = (slotSyncHeight) ? 1 : 0;
                }
                
                // clearBefore
                var slotClearBefore = $('.form-group.clearBefore .is-clearBefore', $this).is(':checked');
                dataSlot['cb'] = (slotClearBefore) ? 1 : 0;
                
                // hAlign
                var slotHAlign = $('.form-group.hAlign .form-control.slot-hAlign', $this).val();
                if (slotHAlign) {
                    dataSlot['ha'] = slotHAlign;
                }
                
                // fixed
                var $fixedWrap = $('.form-group.fixed', $this);
                if ($('.is-fixed', $fixedWrap).is(':checked')) {
                    var
                        nodeSelector = $.trim($('.form-control.fixed-node-selector', $fixedWrap).val()),
                        topOffset = $.trim($('.form-control.fixed-topOffset', $fixedWrap).val());
                    
                    if (nodeSelector != "") {
                        slotFixed['node'] = {};
                        slotFixed['node']['selector'] = nodeSelector;
                    }    
                    if (topOffset != "") slotFixed['topOffset'] = parseInt(topOffset);
                    slotFixed['bottomSync'] = $('.form-control.fixed-bottomSync', $fixedWrap).val();
                }
                
                if (Object.keys(slotFixed).length > 0) {
                    dataSlot['f'] = slotFixed;
                }
                
                // comment
                var slotComment = $.trim($('.form-control.comment', $this).val());
                if (slotComment) {
                    dataSlot['c'] = slotComment;
                }
                
                dataSlots.push(dataSlot);
            });
            
            if (dataSlots.length>0) {
                $('input#slots').val(JSON.stringify(dataSlots));
            }

            // Собираем данные формы:
            $form.find('.form-control').each(function(){
                data[$(this).attr('name')] = $(this).val();
            });       

            // Формируем данные alias:
            data['alias'] = data['alias'].split(', ').join(',');

            if (actionType == 'publish') {
                data['temp_state'] = null;
            } else {
                data['temp_state'] = 1;
            }
            
            // Если изменений в тех.данных не было:
            if (!markerDataIsChanged) {
                data['temp_state'] = null;
                data['only_sale'] = 1;
            }
            if (actionType == 'publish') {
                data['only_sale'] = 0;
            }
            
        }
        
        
        if (warningInfo) {
            alert(warningInfo);
            return false;
        }
        
        //console.log('AAA sites_form data = ', data);
        //return false;
        
        busy = true;
        $.ajax(action, {
            type: method,           
            data: data,           
            success: function(data) {

                busy = false;

                if(data) {
                    //console.log('AAA result = ', data.result);
                    //console.log('AAA msg = ', data.msg);
                    //console.log('AAA redirect = ', data.redirect);

                    if(data.result == true && data.redirect) {
                        window.location.href = data.redirect;
                    }
                    if(data.result == false && data.msg) {
                        $.showMessage('error', data.msg);
                    }
                }                            
            },
            error: function(ajaxObj, textStatus, textError) {
                busy = false;
            }
        });              
      
        return false;
    });
    
});


