<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Entity\AmSystem;

use App\Entity\Common;


/**
 * Class Campaign
 * @package App\Entity
 */
class Campaign extends Common
{
    /* group_id */
    public function getGroupId()
    {
        return $this->groupId;
    }
    public function setGroupId($groupId)
    {
        $this->groupId = $groupId;
        return $this;
    }
    
    /* title */
    public function getTitle()
    {
        return $this->title;
    }
    public function setTitle($title)
    {
        $this->title = $title;
        return $this;
    }
    
    /* active */
    public function getActive()
    {
        return $this->active;
    }
    public function setActive($active)
    {
        $this->active = $active;
        return $this;
    }
    
    /* archive */
    public function getArchive()
    {
        return $this->archive;
    }
    public function setArchive($archive)
    {
        $this->archive = $archive;
        return $this;
    }
    
    /* url */
    public function getUrl()
    {
        return $this->url;
    }
    public function setUrl($url)
    {
        $this->url = $url;
        return $this;
    }
    
    /* checksum */
    public function getChecksum()
    {
        return $this->checksum;
    }
    public function setChecksum($checksum)
    {
        $this->checksum = $checksum;
        return $this;
    }
    
    /* date_begin */
    public function getDateBegin()
    {
        return $this->dateBegin;
    }
    public function setDateBegin($dateBegin)
    {
        $this->dateBegin = $dateBegin;
        return $this;
    }
    
    /* date_end */
    public function getDateEnd()
    {
        return $this->dateEnd;
    }
    public function setDateEnd($dateEnd)
    {
        $this->dateEnd = $dateEnd;
        return $this;
    }
    
    /* buy_type */
    public function getBuyType()
    {
        return $this->buyType;
    }
    public function setBuyType($buyType)
    {
        $this->buyType = $buyType;
        return $this;
    }
    
    /* target_action */
    public function getTargetAction()
    {
        return $this->targetAction;
    }
    public function setTargetAction($targetAction)
    {
        $this->targetAction = $targetAction;
        return $this;
    }
    
    /* price */
    public function getPrice()
    {
        return $this->price;
    }
    public function setPrice($price)
    {
        $this->price = $price;
        return $this;
    }
    
    /* max_speed */
    public function getMaxSpeed()
    {
        return $this->maxSpeed;
    }
    public function setMaxSpeed($maxSpeed)
    {
        $this->maxSpeed = $maxSpeed;
        return $this;
    }
    
    /* money_limit */
    public function getMoneyLimit()
    {
        return $this->moneyLimit;
    }
    public function setMoneyLimit($moneyLimit)
    {
        $this->moneyLimit = $moneyLimit;
        return $this;
    }

    /* visitor_limit */
    public function getVisitorLimit()
    {
        return $this->visitorLimit;
    }
    public function setVisitorLimit($visitorLimit)
    {
        $this->visitorLimit = $visitorLimit;
        return $this;
    }
    
    /* tracking_pixels */
    public function getTrackingPixels()
    {
        return $this->trackingPixels;
    }
    public function setTrackingPixels($trackingPixels)
    {
        $this->trackingPixels = $trackingPixels;
        return $this;
    }
    
    /* targeting */
    public function getTargeting()
    {
        return $this->targeting;
    }
    public function setTargeting($targeting)
    {
        $this->targeting = $targeting;
        return $this;
    }
    
    /* banners */
    public function getBanners()
    {
        return $this->banners;
    }
    public function setBanners($banners)
    {
        $this->banners = $banners;
        return $this;
    }

}