<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Entity;


/**
 * Class Zone
 * @package App\Entity
 */
class Zone extends Common
{
    
    const NOT_HIDDEN = 0;
    const HIDDEN = 1;

    /**
     * @var string
     */
    protected $siteId;
    protected $width;
    protected $height;

    /**
     * @var boolean
     */
    protected $hidden = 0;
    
    /**
     * @return string
     */
    public function getSiteId()
    {
        return $this->siteId;
    }
    
    /**
     * @param string $siteId
     * @return Zone
     */
    public function setSiteId($siteId)
    {
        $this->siteId = $siteId;
        return $this;
    }
    
    /**
     * @return string
     */
    public function getWidth()
    {
        return $this->width;
    }
    
    /**
     * @param string $width
     * @return Zone
     */
    public function setWidth($width)
    {
        $this->width = $width;
        return $this;
    }

    /**
     * @return string
     */
    public function getHeight()
    {
        return $this->height;
    }

    /**
     * @param string $height
     * @return Zone
     */
    public function setHeight($height)
    {
        $this->height = $height;
        return $this;
    }
    
    /**
     * @return int
     */
    public function getMinWindowWidth()
    {
        return $this->minWindowWidth;
    }
            
    /**
     * @param int $minwindowwidth
     * @return Zone
     */
    public function setMinWindowWidth($minwindowwidth)
    {
        $this->minWindowWidth = $minwindowwidth;
        return $this;
    }
    
    /**
     * @return int
     */
    public function getMaxWindowWidth()
    {
        return $this->maxWindowWidth;
    }
    
    /**
     * @param int $maxwindowwidth
     * @return Zone
     */
    public function setMaxWindowWidth($maxwindowwidth)
    {
        $this->maxWindowWidth = $maxwindowwidth;
        return $this;
    }
    
    /**
     * @return int
     */
    public function getHidden()
    {
        return $this->hidden;
    }

    /**
     * @param int $is_hidden
     * @return Zone
     */
    public function setHidden($is_hidden)
    {
        $this->hidden = $is_hidden;
        return $this;
    }
    
    /**
     * @return int
     */
    public function getDisabled()
    {
        return $this->disabled;
    }

    /**
     * @param int $is_disable
     * @return Zone
     */
    public function setDisabled($is_disable)
    {
        $this->disabled = $is_disable;
        return $this;
    }
    
    /**
     * @return int
     */
    public function getDeleted()
    {
        return $this->deleted;
    }

    /**
     * @param int $is_deleted
     * @return Zone
     */
    public function setDeleted($is_deleted)
    {
        $this->deleted = $is_deleted;
        return $this;
    }
    
    
    /**
     * @return string
     */
    public function getSelectors()
    {
        return $this->selectors;
    }
    
    /**
     * @param string $selectors
     * @return Zone
     */
    public function setSelectors($selectors)
    {
        $this->selectors = $selectors;
        return $this;
    }
    
    /**
     * @return string
     */
    public function getMoreSelectors()
    {
        return $this->moreSelectors;
    }
    
    /**
     * @param string $more_selectors
     * @return Zone
     */
    public function setMoreSelectors($more_selectors)
    {
        $this->moreSelectors = $more_selectors;
        return $this;
    }
    
    
    /**
     * @return string
     */
    public function getTargets()
    {
        return $this->targets;
    }
    
    /**
     * @param string $targets
     * @return Zone
     */
    public function setTargets($targets)
    {
        $this->targets = $targets;
        return $this;
    }
    
    
    /**
     * @return string
     */
    public function getStyles()
    {
        return $this->styles;
    }
    
    /**
     * @param string $styles
     * @return Zone
     */
    public function setStyles($styles)
    {
        $this->styles = $styles;
        return $this;
    }
    
    
    /**
     * @return string
     */
    public function getSeq()
    {
        return $this->seq;
    }

    /**
     * @param string $seq
     * @return Zone
     */
    public function setSeq($seq)
    {
        $this->seq = $seq;
        return $this;
    }
    
    /**
     * @return string
     */
    public function getTpl()
    {
        return $this->tpl;
    }

    /**
     * @param string $tpl
     * @return Zone
     */
    public function setTpl($tpl)
    {
        $this->tpl = $tpl;
        return $this;
    }
    
    
    /**
     * @return string
     */
    public function getAddition()
    {
        return $this->addition;
    }

    /**
     * @param string $addition
     * @return Zone
     */
    public function setAddition($addition)
    {
        $this->addition = $addition;
        return $this;
    }
    
    /**
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }
    
    /**
     * @param string $comment
     * @return Zone
     */
    public function setComment($comment)
    {
        $this->comment = $comment;
        return $this;
    }
    
    /**
     * @return string
     */
    public function getMinCpm()
    {
        return $this->minCpm;
    }
    
    /**
     * @param string $minCpm
     * @return Zone
     */
    public function setMinCpm($minCpm)
    {
        $this->minCpm = $minCpm;
        return $this;
    }
    
    
}