$(document).ready(function(){
    
    (function(){
    
    })();
            
    // Выбор дат для Stat http://t1m0n.name/air-datepicker/docs/index-ru.html
    var
        nowDate = new Date(),
        isChangePeriod = false,
        datepicker1 = $('#date-value-1').datepicker({
            dateFormat: "yyyy-mm-dd",
            autoClose: true,
            maxDate: nowDate,
            onSelect: function(fd, d, picker) {
                //console.log('AAA onSelect 1 ', fd, d, picker);
                if (!isChangePeriod) {
                    setPeriodSelectEmpty();
                    requestDataPeriod();
                }
            },
        }).data('datepicker'),
        datepicker2 = $('#date-value-2').datepicker({
            dateFormat: "yyyy-mm-dd",
            autoClose: true,
            maxDate: nowDate,
            onSelect: function(fd, d, picker) {
                if (!isChangePeriod) {
                    setPeriodSelectEmpty();
                    requestDataPeriod();
                }
            },
        }).data('datepicker'),
        $chartStat = $('#chart-graph-stat'),
        $chartTable = $('#table-stat'),
        $chartStatInfo = $('.chart-graph-stat-info'),
        $chartStatError = $('.chart-graph-stat-error'),
        $chartStatLoading = $('.chart-graph-stat-loading'),
        $chartStatErrorMessage = $('.chart-graph-stat-error .message'),
        periodStatsData,
        companyStatsData,
        dataLineChartStat;
        
    // Установка стартовых значений дат:
    //datepicker1.selectDate(new Date($('#date-value-1').val()));
    //datepicker2.selectDate(new Date($('#date-value-2').val()));
    
    // Получение данных для отрисовки графика Stat при старте:
    if ($('#period-stats').val()) {
        periodStatsData = JSON.parse($('#period-stats').val());
    }
    if ($('#company-stats').val()) {
        companyStatsData = JSON.parse($('#company-stats').val());
    }
    // Устанавливаем данные по периоду в качестве стартовых:
    dataLineChartStat = periodStatsData;
    
    //console.log('AAA dataLineChartStat = ', dataLineChartStat);
    
    // Отрисовка графика и таблицы по стартовым данным:
    renderLineChart();
    renderHourTable();
    
    // Смена периода:
    var $periodSelect = $('.form-control.stat-period');
    $periodSelect.on('change', function(){
        var
            period = $(this).val(),
            fromDay,
            toDay;
            
        // Установка значений периода в дате:
        switch(period) {
            case 'today':
                fromDay = nowDate;
                toDay = nowDate;
            toDay;
            break;
            case 'yesterday':
                var yesterdayDate = new Date();
                yesterdayDate.setDate(yesterdayDate.getDate()-1);
                fromDay = yesterdayDate;
                toDay = yesterdayDate;
            break;
            case '7days':
                var prev7day = new Date();
                prev7day.setDate(prev7day.getDate()-7);
                fromDay = prev7day;
                toDay = nowDate;
            break;
            case '30days':
                var prev30day = new Date();
                prev30day.setDate(prev30day.getDate()-30);
                fromDay = prev30day;
                toDay = nowDate;
            break;
            case 'current_month':
                var firstDay = new Date(nowDate.getFullYear(), nowDate.getMonth(), 1);
                fromDay = firstDay;
                toDay = nowDate;
            break;
            case 'prev_month':
                var firstDay = new Date(nowDate.getFullYear(), nowDate.getMonth()-1, 1);
                var lastDay = new Date(nowDate.getFullYear(), nowDate.getMonth(), 0);
                fromDay = firstDay;
                toDay = lastDay;
            break;
            case 'year':
                var firstDay = new Date(nowDate.getFullYear(), 0, 1);
                fromDay = firstDay;
                toDay = nowDate;
            break;
            default:
                //datepicker1.clear();
                //datepicker2.clear();
            break;
        }
        
        isChangePeriod = true;
        datepicker1.selectDate(fromDay);
        datepicker2.selectDate(toDay);
        isChangePeriod = false;
        
        requestDataPeriod();
    });
    
    // Сортировка по колонкам внутри таблицы:
    var $tableHeadCols = $('#table-line thead.metric.sortable th b');
    $tableHeadCols.on('click', function(){
        var $this = $(this);
        
        $tableHeadCols.removeClass('selected');
        $this.addClass('selected').toggleClass('desc');

        if ($this.hasClass('main-cat')) {
            dataLineChartStat = ($this.hasClass('date')) ? periodStatsData : companyStatsData;
        }
        renderHourTable();
    });
    
    // Клик на checkbox в названии поля таблицы:
    var $tableHeadColsChecks = $('#table-line thead.metric.sortable th input[type="checkbox"]');
    $tableHeadColsChecks.on('change', 'thead.metric.sortable th input[type="checkbox"]', function(){
        renderLineChart();
    });
    
    // Отрисовка графика:
    function renderLineChart()
    {
        if(dataLineChartStat && $chartStat.length>0) {
            $.ChartStat.DateStat(dataLineChartStat);
            return false;
        }
    }
    
    // Отрисовка таблицы:
    function renderHourTable()
    {
        if(dataLineChartStat) {
            $.TableStat.Render(dataLineChartStat);
            $chartTable.show();
        } else {
            $chartTable.hide();
        }     
    }
    
    // Запрос данных за временной период:
    function requestDataPeriod()
    {
        console.log('AAA requestDataPeriod');
    }
    
    function setPeriodSelectEmpty()
    {
        $periodSelect.val('');
    }
    
});