$(document).ready(function(){
    
    (function(){
    
    })();
            
    // Выбор дат для Stat http://t1m0n.name/air-datepicker/docs/index-ru.html
    var
        nowDate = new Date(),
        isChangePeriod = false,
        $dateFrom = $('#date-value-1'),
        $dateTo = $('#date-value-2'),
        $periodSelect = $('.form-control.stat-period'),
        isStartDatesSelected = false,
        datepicker1 = $dateFrom.datepicker({
            dateFormat: "yyyy-mm-dd",
            autoClose: true,
            maxDate: nowDate,
            onSelect: function(fd, d, picker) {
                if (isStartDatesSelected) {
                    datepicker2.update('minDate', d);
                    if (!isChangePeriod) {
                        setPeriodSelectEmpty();
                        requestDataPeriod();
                    }
                }
            },
        }).data('datepicker'),
        datepicker2 = $dateTo.datepicker({
            dateFormat: "yyyy-mm-dd",
            autoClose: true,
            maxDate: nowDate,
            onSelect: function(fd, d, picker) {
                if (isStartDatesSelected) {
                    datepicker1.update('maxDate', d);
                    if (!isChangePeriod) {
                        setPeriodSelectEmpty();
                        requestDataPeriod();
                    }
                }
            },
        }).data('datepicker'),
        $chartStat = $('#chart-graph-stat'),
        $chartTable = $('#table-stat'),
        $loading = $('.b-feeds-stat_data-loading'),
        $chartStatInfo = $('.chart-graph-stat-info'),
        $chartStatError = $('.chart-graph-stat-error'),
        $chartStatErrorMessage = $('.chart-graph-stat-error .message'),
        periodStatsData,
        campaignStatsData,
        dataLineChartStat;
    
    
    // Установка стартовых значений дат:
    datepicker1.selectDate(new Date($dateFrom.val()));
    datepicker2.selectDate(new Date($dateTo.val()));
    isStartDatesSelected = true;
    
    
    // Получение данных для отрисовки графика Stat при старте:
    if ($('#period-stats').val()) {
        periodStatsData = JSON.parse($('#period-stats').val());
    }
    if ($('#campaign-stats').val()) {
        campaignStatsData = JSON.parse($('#campaign-stats').val());
    }
    // Устанавливаем данные по периоду в качестве стартовых:
    dataLineChartStat = periodStatsData;
    //console.log('AAA dataLineChartStat = ', dataLineChartStat);
    
    // Отрисовка графика и таблицы по стартовым данным:
    renderLineChart();
    renderHourTable();
    
    // Смена периода:
    $periodSelect.on('change', function(){
        var
            period = $(this).val(),
            fromDay,
            toDay;
            
        // Установка значений периода в дате:
        switch(period) {
            case 'today':
                fromDay = nowDate;
                toDay = nowDate;
            toDay;
            break;
            case 'yesterday':
                var yesterdayDate = new Date();
                yesterdayDate.setDate(yesterdayDate.getDate()-1);
                fromDay = yesterdayDate;
                toDay = yesterdayDate;
            break;
            case '7days':
                var prev7day = new Date();
                prev7day.setDate(prev7day.getDate()-7);
                fromDay = prev7day;
                toDay = nowDate;
            break;
            case '30days':
                var prev30day = new Date();
                prev30day.setDate(prev30day.getDate()-30);
                fromDay = prev30day;
                toDay = nowDate;
            break;
            case 'current_month':
                var firstDay = new Date(nowDate.getFullYear(), nowDate.getMonth(), 1);
                fromDay = firstDay;
                toDay = nowDate;
            break;
            case 'prev_month':
                var firstDay = new Date(nowDate.getFullYear(), nowDate.getMonth()-1, 1);
                var lastDay = new Date(nowDate.getFullYear(), nowDate.getMonth(), 0);
                fromDay = firstDay;
                toDay = lastDay;
            break;
            case 'year':
                var firstDay = new Date(nowDate.getFullYear(), 0, 1);
                fromDay = firstDay;
                toDay = nowDate;
            break;
            default:
                //datepicker1.clear();
                //datepicker2.clear();
            break;
        }
        
        isChangePeriod = true;
        datepicker1.selectDate(fromDay);
        datepicker2.selectDate(toDay);
        isChangePeriod = false;
        
        requestDataPeriod();
    });
    
    // Сортировка по колонкам внутри таблицы:
    var $tableHeadCols = $('#table-line thead.metric.sortable th b');
    $tableHeadCols.on('click', function(){
        var $this = $(this);
        
        $tableHeadCols.removeClass('selected');
        $this.addClass('selected').toggleClass('desc');

        if ($this.hasClass('main-cat')) {
            dataLineChartStat = ($this.hasClass('date')) ? periodStatsData : campaignStatsData;
            $tableHeadColsChecks.attr("disabled", $this.hasClass('campaign'));
        }
        renderHourTable();
    });
    
    // Клик на checkbox в названии поля таблицы:
    var $tableHeadColsChecks = $('#table-line thead.metric.sortable th input[type="checkbox"]');
    $tableHeadColsChecks.on('change', function(){
        renderLineChart();
    });
    
    // Отрисовка графика:
    function renderLineChart()
    {
        if(dataLineChartStat && $chartStat.length>0) {
            $.ChartStat.DateStat(dataLineChartStat);
            return false;
        }
    }
    
    // Отрисовка таблицы:
    function renderHourTable()
    {
        if(dataLineChartStat) {
            $.TableStat.Render(dataLineChartStat);
            $chartTable.show();
        } else {
            $chartTable.hide();
        }     
    }
    
    // Запрос данных за временной период:
    function requestDataPeriod()
    {
        var dataRequest = {period: [$dateFrom.val(),$dateTo.val()]};
        EnableLoadingState(true);
        
        $.ajax({
            url: $periodSelect.attr('data-link'),
            method: 'POST',
            data: dataRequest,
            success: function(res) {
                EnableLoadingState(false);
                if (res == null) {
                    console.log("AAA requestDataStat success res: NULL");
                    ShowInfo();
                } else if (res.status == 'Error') {
                    console.log("AAA requestDataStat error");
                    ShowError();
                } else {
                    //console.log("AAA requestDataStat SUCCESS res: ", res);
                    ShowChartData();
                    
                    periodStatsData = res.period;
                    campaignStatsData = res.campaign; 
                    dataLineChartStat = periodStatsData;
                    $('.main-cat').removeClass('selected');
                    $('.main-cat.date').addClass('selected');
                    renderLineChart();
                    renderHourTable();
                }
            },
            error: function (e) {
                console.log('error: ', e);
                EnableLoadingState(false);
            }
        });
    }
    
    function setPeriodSelectEmpty()
    {
        $periodSelect.val('');
    }
    
    function setPeriodSelectEmpty()
    {
        $periodSelect.val('');
    }
    
    function EnableLoadingState(isLoading)
    {
        if (isLoading) {
            $loading.show();
        } else {
            $loading.hide();
        }
    }
    
    function ShowInfo()
    {
        $chartStatInfo.show();
        $chartStatError.hide();
        $chartStat.hide();
        $chartTable.hide();
    }
    
    function ShowError()
    {
        $chartStatError.show();
        $chartStatInfo.hide();
        $chartStat.hide();
        $chartTable.hide();
    }
    
    function ShowChartData()
    {
        $chartStatInfo.hide();
        $chartStatError.hide();
        $chartStat.show();
        $chartTable.show();
    }
    
    
});