$(document).ready(function () {
    "use strict";
    
    Array.prototype.forEach.call(document.querySelectorAll("button[data-delete]"), function (el) {
        $(el).on("click", function (e) {
            e.stopPropagation();

            $.ajax(this.getAttribute("data-delete"), {
                type: "POST",
                item: this,
                success: function (data) {
                    console.log(data);
                    if (data.result) {
                        document.location.reload();
                    }
                },
                error: function(req, status, err) {
                    console.log(status, err);
                    document.location.reload();
                }
            });
        });
    });
    
    Array.prototype.forEach.call(document.querySelectorAll("button[data-link]"), function (el) {
        $(el).on("click", function (e) {
            e.stopPropagation();
            document.location.href = this.getAttribute("data-link");
            
            /*
            var $this = $(this);
            $.ajax({
                url: $this.attr("data-link"),
                type: "POST",
                contentType: false,
                processData: false,
                data: {
                    manager: $this.attr("data-id")
                },
                successUrl: $this.attr("data-link"),
                success: function(data) {
                    console.log('success ', data);
                    
                },
                error: function (e) {
                    console.log('error: ', e);
                }
            });
            */
        });
    });
    
    $('#support-create-form').on('submit', function(e) {            
        e.stopPropagation();
        
        var action = $(this).attr('action');
        var method = $(this).attr('method');
        var formData = {};
        
        var vals = $(this).serializeArray();
        if(vals.length) {
            for(var i in vals) {
                formData[vals[i].name] = vals[i].value;                              
            }
        }       
        
        $.ajax(action, {
            type: method,
            data: formData,
            success: function(data) {
                if(data) {
                    if(data.result === true && data.redirect) {
                        document.location.href = data.redirect;
                    }
                    if(data.result === false && data.msg) {
                        $.showMessage('error', data.msg);
                    }
                } 
            },
            error: function(rew, status, err) {
                console.log(status, err);                    
            }
        });
        
        return false;
    });        
});

