<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Entity;


/**
 * Class Site
 * @package App\Entity
 */
class Site extends Common
{

    /**
     * @var string
     */
    protected $domain;
    protected $usersId;
    protected $alias;
    protected $category;
    
    
    /**
     * @return string
     */
    public function getDomain()
    {
        return $this->domain;
    }

    /**
     * @param string $domain
     * @return Site
     */
    public function setDomain($domain)
    {
        $this->domain = $domain;
        return $this;
    }

    /**
     * @return int
     */
    public function getUsersId()
    {
        return $this->usersId;
    }

    /**
     * @param int $usersId
     * @return Site
     */
    public function setUsersId($usersId)
    {
        $this->usersId = $usersId;
        return $this;
    }


    /**
     * @return string
     */
    public function getAlias()
    {
        return $this->alias;
    }

    /**
     * @param string $alias
     * @return Site
     */
    public function setAlias($alias)
    {
        $this->alias = $alias;
        return $this;
    }

    
    /**
     * @return string
     */
    public function getCategory()
    {
        return $this->category;
    }

    /**
     * @param string $category
     * @return Site
     */
    public function setCategory($category)
    {
        $this->category = $category;
        return $this;
    }
   
    
    /**
     * Set dateCreate
     *
     * @param string $dateCreate
     *
     * @return User
     */
    public function setDateCreate($dateCreate)
    {
        $this->dateCreate = $dateCreate;

        return $this;
    }

    /**
     * Get dateCreate
     *
     * @return string
     */
    public function getDateCreate()
    {
        return $this->dateCreate ?? (new \DateTimeImmutable())->format('Y-m-d');
    }
    
    /**
     * 
     * @return int
     */
    public function getTraffic(): int
    {
        return (int) $this->traffic;
    }
            
    /**
     * 
     * @param int $traffic
     * @return $this
     */
    public function setTraffic($traffic)
    {
        $this->traffic = $traffic;
        return $this;
    }
    
    
    /**
     * @param bool $onlyNative
     * @return Site
     */
    public function setOnlyNative($onlyNative)
    {
        $this->onlyNative = $onlyNative;
        return $this;
    }
    
    /**
     * @return bool
     */
    public function getOnlyNative()
    {
        return $this->onlyNative;
    }
    
    /**
     * @param bool $forcedStart
     * @return Site
     */
    public function setForcedStart($forcedStart)
    {
        $this->forcedStart = $forcedStart;
        return $this;
    }
    
    /**
     * @return bool
     */
    public function getForcedStart()
    {
        return $this->forcedStart;
    }
    
    
    /**
     * @param bool $payBlock
     * @return Site
     */
    public function setPayBlock($payBlock)
    {
        $this->payBlock = $payBlock;
        return $this;
    }
    
    /**
     * @return bool
     */
    public function getPayBlock()
    {
        return $this->payBlock;
    }
    
    /**
     * @param bool $onlyGoods
     * @return Site
     */
    public function setOnlyGoods($onlyGoods)
    {
        $this->onlyGoods = $onlyGoods;
        return $this;
    }
    
    /**
     * @return bool
     */
    public function getOnlyGoods()
    {
        return $this->onlyGoods;
    }

    
    /**
     * @return string
     */
    public function getHidezones()
    {
        return $this->hidezones;
    }

    /**
     * @param string $hidezones
     * @return Site
     */
    public function setHidezones($hidezones)
    {
        $this->hidezones = $hidezones;
        return $this;
    }
    
    
    /**
     * @return string
     */
    public function getStophide()
    {
        return $this->stophide;
    }

    /**
     * @param string $stophide
     * @return Site
     */
    public function setStophide($stophide)
    {
        $this->stophide = $stophide;
        return $this;
    }
    
    
    /**
     * @return string
     */
    public function getProvidersId()
    {
        return $this->providersId;
    }

    /**
     * @param string $providersId
     * @return Site
     */
    public function setProvidersId($providersId)
    {
        $this->providersId = $providersId;
        return $this;
    }

    
    /**
     * @return string
     */
    public function getCodezones()
    {
        return $this->codezones;
    }

    /**
     * @param string $codezones
     * @return Site
     */
    public function setCodezones($codezones)
    {
        $this->codezones = $codezones;
        return $this;
    }
    
    /**
     * @return string
     */
    public function getTempState()
    {
        return $this->tempState;
    }

    /**
     * @param string $tempState
     * @return Site
     */
    public function setTempState($tempState)
    {
        $this->tempState = $tempState;
        return $this;
    }
    
    /**
     * @return int
     */
    public function getEnabled()
    {
        return $this->enabled;
    }

    /**
     * @param int $is_enable
     * @return Zone
     */
    public function setEnabled($is_enable)
    {
        $this->enabled = $is_enable;
        return $this;
    }
    
    /**
     * @return string
     */
    public function getServerData()
    {
        return $this->serverData;
    }

    /**
     * @param string $serverData
     * @return Site
     */
    public function setServerData($serverData)
    {
        $this->serverData = $serverData;
        return $this;
    }
    
}