<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Entity\Statistic;


/**
 * Class Site
 *
 * @package App\Entity\Statistic
 */
class Site
{

    const PROP_USERS_WITH_ADBLOCKER = 0;
    const PROP_USERS_WITHOUT_ADBLOCKER = 1;
    const PROP_LOSS_TOTAL = 2;
    const PROP_LOSS_DAY = 3;
    const PROP_LOSS_WEEK = 4;
    const PROP_LOSS_PER1000VIEWS = 5;
    const PROP_RECOVERED = 6;

    const PATTERN_USERS_WITH_ADBLOCKER = '%s пользователей блокируют рекламу';
    const PATTERN_USERS_WITHOUT_ADBLOCKER = '%s пользователей не устанавливали блокировщик';
    const TITLE_LOSS_TOTAL = 'Всего потери';
    const TITLE_LOSS_DAY = 'За день';
    const TITLE_LOSS_WEEK = 'За неделю';
    const TITLE_LOSS_PER1000VIEWS = 'За 1000 показов';
    const TITLE_RECOVERED = 'Восстановлено';

    /**
     * @var Data
     */
    protected $usersWithAdBlocker;
    /**
     * @var Data
     */
    protected $usersWithoutAdBlocker;

    /**
     * @var Data
     */
    protected $lossTotal;
    /**
     * @var Data
     */
    protected $lossDay;
    /**
     * @var Data
     */
    protected $lossWeek;
    /**
     * @var Data
     */
    protected $lossPer1000views;
    /**
     * @var Data
     */
    protected $recovered;
    /**
     *
     * @var int
     */
    protected $sitesCount;

    /**
     * @return Data
     */
    public function getUsersWithAdBlocker(): Data
    {
        if (is_null($this->usersWithAdBlocker)) {
            $this->usersWithAdBlocker = new Data();
        }
        return $this->usersWithAdBlocker;
    }

    /**
     * @param Data $usersWithAdBlocker
     * @return Site
     */
    public function setUsersWithAdBlocker(Data $usersWithAdBlocker): Site
    {
        $this->usersWithAdBlocker = $usersWithAdBlocker;
        return $this;
    }

    /**
     * @return Data
     */
    public function getUsersWithoutAdBlocker(): Data
    {
        if (is_null($this->usersWithoutAdBlocker)) {
            $this->usersWithoutAdBlocker = new Data();
        }
        return $this->usersWithoutAdBlocker;
    }

    /**
     * @param Data $usersWithoutAdBlocker
     * @return Site
     */
    public function setUsersWithoutAdBlocker(Data $usersWithoutAdBlocker): Site
    {
        $this->usersWithoutAdBlocker = $usersWithoutAdBlocker;
        return $this;
    }

    /**
     * @return Data
     */
    public function getLossTotal(): Data
    {
        if (is_null($this->lossTotal)) {
            $this->lossTotal = new Data();
        }
        return $this->lossTotal;
    }

    /**
     * @param Data $lossTotal
     * @return Site
     */
    public function setLossTotal(Data $lossTotal): Site
    {
        $this->lossTotal = $lossTotal;
        return $this;
    }

    /**
     * @return Data
     */
    public function getLossDay(): Data
    {
        if (is_null($this->lossDay)) {
            $this->lossDay = new Data();
        }
        return $this->lossDay;
    }

    /**
     * @param Data $lossDay
     * @return Site
     */
    public function setLossDay(Data $lossDay): Site
    {
        $this->lossDay = $lossDay;
        return $this;
    }

    /**
     * @return Data
     */
    public function getLossWeek(): Data
    {
        if (is_null($this->lossWeek)) {
            $this->lossWeek = new Data();
        }
        return $this->lossWeek;
    }

    /**
     * @param Data $lossWeek
     * @return Site
     */
    public function setLossWeek(Data $lossWeek): Site
    {
        $this->lossWeek = $lossWeek;
        return $this;
    }

    /**
     * @return Data
     */
    public function getLossPer1000views(): Data
    {
        if (is_null($this->lossPer1000views)) {
            $this->lossPer1000views = new Data();
        }
        return $this->lossPer1000views;
    }

    /**
     * @param Data $lossPer1000views
     * @return Site
     */
    public function setLossPer1000views(Data $lossPer1000views): Site
    {
        $this->lossPer1000views = $lossPer1000views;
        return $this;
    }

    /**
     * @return Data
     */
    public function getRecovered(): Data
    {
        if (is_null($this->recovered)) {
            $this->recovered = new Data();
        }
        return $this->recovered;
    }

    /**
     * @param Data $recovered
     * @return Site
     */
    public function setRecovered(Data $recovered): Site
    {
        $this->recovered = $recovered;
        return $this;
    }

    public function getSitesCount()
    {
        return $this->sitesCount;
    }

    public function setSitesCount($sites)
    {
        $this->sitesCount = $sites;
        return $this;
    }

}