<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Model\Feeds;

use App\Model\Common;


/**
 * Class StatsDays
 * @package App\Model
 */
class StatsDays extends Common
{
    
    public function getStatsByFeeds($feeds)
    {
        $adapter = $this->tableGateway->getAdapter();
        
        $sql = 'SELECT FeedID, SUM(Shows) AS Shows, SUM(Clicks) AS Clicks, SUM(Transactions) AS Transactions, SUM(SaleMoney) AS SaleMoney, SUM(AdMoney) AS AdMoney'
                . ' FROM ' . (string) $this->tableGateway->getTable()
                . ' WHERE FeedID in (\''.implode('\',\'', $feeds).'\')'
                . ' GROUP BY FeedID'
                . ' ORDER BY FeedID';
        $res = $adapter->query($sql, \Zend\Db\Adapter\Adapter::QUERY_MODE_EXECUTE);
        
        $stats = array(
            'period' => [],
            'shows' => [],
            'clicks' => [],
            'transactions' => [],
            'salemoney' => [],
            'admoney' => [],
        );

        foreach($res as $stat_item) {
            $stats['period'][] = $stat_item['FeedID'];
            $stats['shows'][] = (int)$stat_item['Shows'];
            $stats['clicks'][] = (int)$stat_item['Clicks'];
            $stats['transactions'][] = (int)$stat_item['Transactions'];
            $stats['salemoney'][] = (float)$stat_item['SaleMoney'];
            $stats['admoney'][] = (float)$stat_item['AdMoney'];
        }
        
        return $stats;
    }
    
    public function getStatsByDate($feeds)
    {
        $adapter = $this->tableGateway->getAdapter();
        
        $sql = 'SELECT EventDate, SUM(Shows) AS Shows, SUM(Clicks) AS Clicks, SUM(Transactions) AS Transactions, SUM(SaleMoney) AS SaleMoney, SUM(AdMoney) AS AdMoney'
                . ' FROM ' . (string) $this->tableGateway->getTable()
                . ' WHERE FeedID in (\''.implode('\',\'', $feeds).'\')'
                . ' GROUP BY EventDate'
                . ' ORDER BY EventDate desc';
        $res = $adapter->query($sql, \Zend\Db\Adapter\Adapter::QUERY_MODE_EXECUTE);
        
        $stats = array(
            'period' => [],
            'shows' => [],
            'clicks' => [],
            'transactions' => [],
            'salemoney' => [],
            'admoney' => [],
        );

        foreach($res as $stat_item) {
            $stats['period'][] = $stat_item['EventDate'];
            $stats['shows'][] = (int)$stat_item['Shows'];
            $stats['clicks'][] = (int)$stat_item['Clicks'];
            $stats['transactions'][] = (int)$stat_item['Transactions'];
            $stats['salemoney'][] = (float)$stat_item['SaleMoney'];
            $stats['admoney'][] = (float)$stat_item['AdMoney'];
        }
        
        return $stats;
    }
    
}