<?php

namespace App\Validator;

use Zend\Validator\Hostname;
use Zend\Validator\EmailAddress;



class Add extends Common 
{
    
    const ALL_FIELDS = ['title','desc','link', 'price', 'template_values'];
    const REQUIRED_FIELDS = ['title','desc','link'];
    
    public function isValid($add) 
    {
        foreach (self::ALL_FIELDS as $field) {
            if(in_array($field, self::REQUIRED_FIELDS) && !$add[$field]) {
                $msg = 'пустое поле '. $field;
            }
            
            if (!preg_match("/\\$\[[a-zA-Z0-9\-\_]*\]/", $add[$field])) {
                if ($field == 'title' && mb_strlen($add[$field])>50) {
                    $msg = 'превышена длинна в 50 символов у поля '. $field;
                }
                if ($field == 'desc' && mb_strlen($add[$field])>50) {
                    $msg = 'превышена длинна в 50 символов у поля '. $field;
                }
                if ($field == 'price' && $add[$field] && mb_strlen($add[$field])>8) {
                    $msg = 'превышена длинна в 8 символов у поля '. $field;
                }
            }
            
            if ($field == 'link') {
                
                // Фиктивно меняем шаблоны типа $[...] и ${...}
                $link_text = $add[$field];
                $link_text = preg_replace("/\\$\[([a-zA-Z0-9\-\_]*)\]/", "ttt", $link_text);
                $link_text = preg_replace("/\\$\{([a-zA-Z0-9\-\_]*)\}/", "ttt", $link_text);
                
                if (!preg_match("~^(?:((?:https?|ftp|telnet):)?//(?:[a-z0-9_-]{1,32}".
                "(?::[a-z0-9_-]{1,32})?@)?)?(?:(?:[a-z0-9-]{1,128}\.)+(?:com|net|".
                "org|mil|edu|arpa|gov|biz|info|aero|inc|name|[a-z]{2})|(?!0)(?:(?".
                "!0[^.]|255)[0-9]{1,3}\.){3}(?!0|255)[0-9]{1,3})(?:/[a-z0-9.,_@%&".
                "?+=\~/-]*)?(?:#[^ '\"&<>]*)?$~i",$link_text)) {
                    $msg = 'Ошибочный URL '. $add[$field];
                }
            }
            
            if ($field == 'template_values' && $add[$field]) {
                $data_template_values = json_decode($add[$field], true);
                foreach ($data_template_values as $id => $values) {
                    if ($id == '') {
                        $msg = 'Empty data fields for templates variables';
                    }
                    foreach ($values as $name=> $val) {
                        if ($val == '') {
                            $msg = 'Empty data fields for templates variables';
                        }
                    }
                }
            }
            
            if ($msg) {
                return [
                    result => false,
                    msg => $msg
                ];
            }
            
        }
        return [
            result => true
        ];
        
    }
    
    protected function validateInstance($entity)
    {            
        return $entity instanceof \App\Entity\Add;
    }

    
}
