;(function($){

	var jqPluginName = 'sortAmsystemTable';

	var sortPlugin = function(element, options) {
            
            var self = this;

            var config = $.extend(true, {}, $.fn[jqPluginName].defaults, options);
            config.context = element;
            
            config.$columnItems = $(config.columnItems, config.context);
            config.isParentStructure = $('tr[data-parent]', config.context).length>0;
            
            this.addDataItems = function() {
                
                config.dataItems = [];
                config.$itemsRows = $(config.itemsRows, config.context);
                
                var $itemRow;
                config.$itemsRows.each(function(i, e){
                    $itemRow = $(e);
                    var itemData = {
                        tr: $itemRow, // строка в таблице
                    };
                    
                    config.$columnItems.each(function(){
                        var
                            sortName = $.trim($(this).data('sort')),
                            sortValue = $('td[data-cat="' + sortName + '"]', $itemRow).data('value');
                        
                        itemData[sortName] = sortValue;
                    });
                    config.dataItems.push(itemData);
                });
            }
            
            this.filterItems = function(field) {
                config.$columnItems.filter('[data-sort="' + field + '"]').click();
            }
            
            // Клик по названию колонки для сортировки:
            config.$columnItems.click(function() {
                
                // Сортировка в таблице
                var
                    $columnItem = $(this),
                    sortField = $columnItem.data('sort'),
                    sortAsc = $columnItem.attr('data-sortasc');
                    
                config.$columnItems.removeClass('selected');
                $columnItem.attr('data-sortasc', -sortAsc);
                $columnItem.removeClass('asc').removeClass('desc').addClass('selected').addClass((-sortAsc > 0) ? 'asc' : 'desc');

                config.dataItems.sort(function(a, b) {
                    if (sortAsc < 0) {
                        return (a[sortField] > b[sortField]) ? 1 : -1;
                    } else {
                        return (a[sortField] < b[sortField]) ? 1 : -1;
                    }
                });
                
                // Доп. сортровка данных для родительских структуры внутри таблицы:
                if (config.isParentStructure) {
                    var dataItemsTemp = [],id;
                    
                    config.dataItems.forEach(function(item, i){
                        if (item.tr.hasClass('group-item')) {
                            dataItemsTemp.push(item);
                            id = item.tr.data('id');
                            config.dataItems.forEach(function(item, i){
                                if (item.tr.data('parent') == id) {
                                    dataItemsTemp.push(item);
                                }
                            });
                        }
                    });
                    config.dataItems = dataItemsTemp;
                }
                
                // Переписываем таблицу:
                var 
                    $table = $(config.context),
                    $tableBody = $('tbody', $table),
                    $tableContent = $('<tbody>');
                
                for (var i = 0; i < config.dataItems.length; i++) {
                    (config.dataItems[i].tr).appendTo($tableContent);
                }
                
                $tableBody.html('').append($tableContent.children());
                
            });
            
            self.InitData = function() {
                this.addDataItems();
            }
            
            this.addDataItems();
            this.filterItems(config.defaultSortField);
                
            config.context.data(jqPluginName, this);
	}

	$.fn[jqPluginName] = function(options) {
            return this.each(function() {
                var _this = $(this);
                if (!_this.data(jqPluginName))
                {
                    new sortPlugin(_this, options);
                }
            });
	}

	$.fn[jqPluginName].defaults = {
            context: null,
            dataItems: [],
            itemsRows: 'tbody tr',
            $itemsRows: null,
            columnItems: '.sort[data-sort]',
            $columnItems: null,
            fieldsInt: ['id', 'views', 'clicks', 'orders', 'reach', 'order_cnt'],
            fieldsFloat: ['cl', 'money', 'ctr', 'cpc', 'cpm', 'order_money'],
            isParentStructure: false,
            defaultSortField: 'views'
	}

})(jQuery);
