$(document).ready(function () {
    "use strict";
    var paginatorContainer = document.getElementsByClassName("b-content__paginator")[0];
    var containerBlogList = document.getElementsByClassName("b-content__container")[0];
    var blogDataSourceUrl = containerBlogList.getAttribute("data-url");
    var spanPaginator = paginatorContainer.getElementsByTagName("span");
    var containerTags = document.getElementsByClassName("tag-container")[0];


    function renderBlogItem(el) {

        var container = document.getElementsByClassName("b-content__container")[0];

        var a = document.createElement("a");
        a.className = "blog-item__inner col sm-4 xs-6";
        a.setAttribute("href", el.link);

        var div = document.createElement("div");
        div.className = "blog-item__bg";
        a.appendChild(div);

        var img = document.createElement("img");
        img.setAttribute("src", el.linkTitleImg);
        div.appendChild(img);

        var pBold = document.createElement("p");
        pBold.className = "text bold";
        pBold.innerHTML = el.dateBlogPublication;
        a.appendChild(pBold);

        var h2 = document.createElement("h2");
        h2.innerHTML = el.titleBlog;
        a.appendChild(h2);

        var pText = document.createElement("p");
        pText.className = "text";
        pText.setAttribute("data-clamp", "");
        pText.innerHTML = "<span>" + el.descriptionBlog + "</span>";
        a.appendChild(pText);

        container.appendChild(a);
    }

    function renderTagItem(el) {
        var tag = document.createElement("a");
        tag.setAttribute("href", el.link);
        tag.setAttribute("class", "tag");
        if (el.current) {
            tag.setAttribute("data-current", "");
        }
        tag.innerHTML = el.text;
        containerTags.appendChild(tag);
    }

    function clampText() {
        $(".blog-item__inner p.text[data-clamp]").each(function (index, el) {
            $clamp(el, {clamp: 6});
        });
    }

    function goToPage(e) {
        var numberPage;
        var target = e.target;
        if (target.tagName !== "SPAN") {
            return;
        }
        numberPage = target.innerHTML;

        $.ajax({
            url: blogDataSourceUrl,
            type: "POST",
//        contentType: false,
//        processData: false,
            data: {
                "page": numberPage
            },
            success: function (response) {
                containerBlogList.innerHTML = "";
                containerTags.innerHTML = "";
                console.log(response);
                Array.prototype.forEach.call(response.tags, renderTagItem);
                Array.prototype.forEach.call(response.data, renderBlogItem);
                Array.prototype.forEach.call(spanPaginator, function (el) {
                    el.className = "";
                });
                spanPaginator[numberPage - 1].className = "current-page";
            },
            error: function (e) {
                console.log("error: ", e);
            }
        });

    }

    $.ajax(blogDataSourceUrl, {
        type: "POST",
        dataType: "json",
        success: function (response) {
            containerBlogList.innerHTML = "";
            containerTags.innerHTML = "";
            Array.prototype.forEach.call(response.tags, renderTagItem);
            Array.prototype.forEach.call(response.data, renderBlogItem);
            clampText();
            paginatorContainer.firstElementChild.className = "current-page";
        },
        error: function (req, status, err) {
            console.log("Error " + req, status, err);
        }
    });

    paginatorContainer.addEventListener("click", goToPage);

});