<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Action\Admin;


use App\Authentication\SupportService as AuthenticationService;
use App\Authentication\Tokenizer\Authentication;
use App\Authentication\UserService;
use Dflydev\FigCookies\SetCookie;
use Dflydev\FigCookies\SetCookies;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Zend\Diactoros\Response\JsonResponse;
use Zend\Hydrator\DelegatingHydrator;

/**
 * Class Login
 * @package App\Action\Admin
 */
class Login extends Common
{

    /**
     * @param ServerRequestInterface $request
     * @param ResponseInterface $response
     * @param callable|null $next
     * @return ResponseInterface|JsonResponse
     */
    function __invoke(ServerRequestInterface $request, ResponseInterface $response, callable $next = null)
    {

        $data = [
            'email' => $request->getParsedBody()['email'],
            'password' => $request->getParsedBody()['password'],
            'remember_pass' => $request->getParsedBody()['remember-pass'] ?? null,
        ];

        /** @var UserService $auths */
        $auths = $this->container->get(AuthenticationService::class);
        /** @var Authentication $tokenizer */
        $tokenizer = $this->container->get(Authentication::class);
        /** @var DelegatingHydrator $hydrator */
        $hydrator = $this->container->get(DelegatingHydrator::class);

        $auths->setCredential($data);

        $result = $auths->authenticate();

        if ($result->isValid()) {

            $token = $tokenizer->encode($hydrator->extract($result->getIdentity()));

            $tokenCookie = SetCookie::create($auths->getCookieTokenName())
                ->withExpires($data['remember_pass'] ? new \DateTime('+1 week') : 0)
                ->withMaxAge(0)
                ->withDomain($request->getUri()->getHost())
                ->withPath('/')
                ->withValue($token);

            $response = new JsonResponse([
                'result' => true,
                'type' => 'support',
                'token' => (string) $tokenCookie
            ]);

            /** @var SetCookies $cookies */
            $cookies = SetCookies::fromResponse($response);
            $cookies = $cookies->with($tokenCookie);

            $response = $cookies->renderIntoSetCookieHeader($response);

        } else {
            $messages = $result->getMessages();
            $response = new JsonResponse(['result' => false, 'msg' => reset($messages)]);
            $response->withStatus(502, $result->getMessages());
        }

        return $response;

    }
}