<?php

use Interop\Container\ContainerInterface;

return [
    'dependencies' => [
        'invokables' => [
            Zend\Expressive\Router\RouterInterface::class => Zend\Expressive\Router\ZendRouter::class,
        ],
        'factories' => [
            App\Action\Logout::class => function (ContainerInterface $container) {
                return new \App\Action\Logout(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\User\Register::class => function (ContainerInterface $container) {
                return new \App\Action\User\Register(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\User\Login::class => function (ContainerInterface $container) {
                return new \App\Action\User\Login(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\Index::class => function (ContainerInterface $container) {
                return new App\Action\Index(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\Statistics::class => function(ContainerInterface $container) {
                return new App\Action\Statistics(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            
            App\Action\FAQ::class => function(ContainerInterface $container) {
                return new App\Action\FAQ(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\User\Cabinet::class => function(ContainerInterface $container) {
                return new App\Action\User\Cabinet(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\User\ViewId::class => function(ContainerInterface $container) {
                return new App\Action\User\ViewId(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\User\Profile::class => function(ContainerInterface $container) {
                return new App\Action\User\Profile(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\Contacts::class => function(ContainerInterface $container) {
                return new App\Action\Contacts(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\Blog::class => function(ContainerInterface $container) {
                return new App\Action\Blog(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\DownloadCounter::class => function(ContainerInterface $container) {
                return new App\Action\DownloadCounter(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\InstallCounter::class => function(ContainerInterface $container) {
                return new App\Action\InstallCounter(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\EmailCounter::class => function(ContainerInterface $container) {
                return new App\Action\EmailCounter(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\User\Activate::class => function(ContainerInterface $container) {
                return new App\Action\User\Activate(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\User\Mail::class => function(ContainerInterface $container) {
                return new App\Action\User\Mail(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\User\PasswordReset::class => function(ContainerInterface $container) {
                return new App\Action\User\PasswordReset(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\Site::class => function(ContainerInterface $container) {
                return new App\Action\Site(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
        ],
    ],

    'routes' => [
        [
            'name' => 'home',
            'path' => '/[:lang/]',
            'middleware' => App\Action\Index::class,
            'allowed_methods' => ['GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG,
                ]
            ],
        ],
        [
            'name' => 'register',
            'path' => '/[:lang/]reg/',
            'middleware' => App\Action\User\Register::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG,
                ]
            ],
        ],
        [
            'name' => 'login',
            'path' => '/[:lang/]login/',
            'middleware' => App\Action\User\Login::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG,
                ]
            ],
        ],
        [
            'name' => 'logout',
            'path' => '/[:lang/]logout/',
            'middleware' => App\Action\Logout::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG,
                ]
            ],
        ],
        [
            'name' => 'user.activate',
            'path' => '/[:lang/]activate/:token',
            'middleware' => App\Action\User\Activate::class,
            'allowed_methods' => ['GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG,
                ]
            ],
        ],
        [
            'name' => 'user.mail.request.activate.protection',
            'path' => '/[:lang/]mail/request/activate-protection/',
            'middleware' => App\Action\User\Mail::class,
            'allowed_methods' => ['POST'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG,
                    'action' => \App\Action\User\Mail::REQUEST_ACTIVATE_PROTECTION,
                ]
            ],
        ],
        [
            'name' => 'user.mail.send.activation',
            'path' => '/[:lang/]mail/send/activation/',
            'middleware' => App\Action\User\Mail::class,
            'allowed_methods' => ['GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG,
                    'action' => \App\Action\User\Mail::SEND_ACTIVATION,
                ]
            ],
        ],
        [
            'name' => 'user.mail.sent.password',
            'path' => '/[:lang/]mail/sent/password/',
            'middleware' => App\Action\User\Mail::class,
            'allowed_methods' => ['GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG,
                    'action' => \App\Action\User\Mail::SEND_PASSWORD,
                ]
            ],
        ],
        [
            'name' => 'user.password.reset',
            'path' => '/[:lang/]password/reset/',
            'middleware' => App\Action\User\PasswordReset::class,
            'allowed_methods' => ['POST'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG,
                ]
            ],
        ],
        [
            'name' => 'statistics',
            'path' => '/[:lang/]statistics/',
            'middleware' => App\Action\Statistics::class,
            'allowed_methods' => ['POST'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',                    
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG,                    
                ]
            ],
        ],
        [
            'name' => 'faq',
            'path' => '/[:lang/]faq/',
            'middleware' => App\Action\FAQ::class,
            'allowed_methods' => ['GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG,
                ]
            ],
        ],
        [
            'name' => 'user.cabinet',
            'path' => '/[:lang/]cabinet/[:report]',
            'middleware' => App\Action\User\Cabinet::class,
            'allowed_methods' => ['GET', 'POST'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                    'report' => '\w+',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG,
                    'action' => App\Action\User\Cabinet::ACTION_STAT,
                    'report' => 'common',
                ]
            ],
        ],
        [
            'name' => 'user.cabinet.viewid',
            'path' => '/[:lang/]cabinet/viewid/:feedid/:id',
            'middleware' => App\Action\User\ViewId::class,
            'allowed_methods' => ['GET', 'POST'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                    'feedid' => '\w+',
                    'id' => '\w+',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG,
                    'action' => App\Action\User\ViewId::ACTION_STAT,
                ]
            ],
        ],
        [
            'name' => 'user.cabinet.profile',
            'path' => '/[:lang/]cabinet/profile/',
            'middleware' => App\Action\User\Profile::class,
            'allowed_methods' => ['GET', 'POST'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG,
                ]
            ],
        ],
        [
            'name' => 'contacts',
            'path' => '/[:lang/]contacts/',
            'middleware' => App\Action\Contacts::class,
            'allowed_methods' => ['GET', 'POST'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG,
                ]
            ],
        ],
        
        [
            'name' => 'download.counter',
            'path' => '/[:lang/]download-counter/[:siteId]',
            'middleware' => App\Action\DownloadCounter::class,
            'allowed_methods' => ['GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG,
                    'siteId' => "",
                ]
            ],
        ],
        [
            'name' => 'install.counter',
            'path' => '/[:lang/]install-counter/[:siteId]',
            'middleware' => App\Action\InstallCounter::class,
            'allowed_methods' => ['GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG,
                    'siteId' => "",
                ]
            ],
        ],
        [
            'name' => 'email.counter',
            'path' => '/[:lang/]email-counter/',
            'middleware' => App\Action\EmailCounter::class,
            'allowed_methods' => ['POST'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG,
                ]
            ],
        ],
    ],
];
