<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Entity\Feeds;

use App\Entity\Common;


/**
 * Class Feed
 * @package App\Entity
 */
class Feed extends Common
{
    
    /**
     * @return mixed
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param mixed $title
     * @return Feed
     */
    
    public function setTitle($title)
    {
        $this->title = $title;
        return $this;
    }
    
    
    /**
     * @return mixed
     */
    public function getClientid(): int
    {
        return $this->clientid;
    }

    /**
     * @param mixed $client_id
     * @return Feed
     */
    public function setClientid($client_id)
    {
        $this->clientid = $client_id;
        return $this;
    }
    
    /**
     * @return mixed
     */
    public function getUrl()
    {
        return $this->url;
    }

    /**
     * @param mixed $url
     * @return Feed
     */
    public function setUrl($url)
    {
        $this->url = $url;
        return $this;
    }
    
    /**
     * @return mixed
     */
    public function getFormat()
    {
        return $this->format;
    }

    /**
     * @param mixed $format
     * @return Feed
     */
    public function setFormat($format)
    {
        $this->format = $format;
        return $this;
    }
    
    /**
     * @return mixed
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * @param mixed $active
     * @return Feed
     */
    public function setActive($active)
    {
        $this->active = $active;
        return $this;
    }
    
    /**
     * @return mixed
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param mixed $status
     * @return Feed
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }
    
    /**
     * @return mixed
     */
    public function getDefaultcur()
    {
        return $this->defaultcur;
    }

    /**
     * @param mixed $default_cur
     * @return Feed
     */
    public function setDefaultcur($default_cur)
    {
        $this->defaultcur = $default_cur;
        return $this;
    }
    
    
    /**
     * @return mixed
     */
    public function getGoodscount()
    {
        return $this->goodscount;
    }

    /**
     * @param mixed $goods_count
     * @return Feed
     */
    public function setGoodscount($goods_count)
    {
        $this->goodscount = $goods_count;
        return $this;
    }
    
    
    /**
     * @return mixed
     */
    public function getLastcheck()
    {
        return $this->lastcheck;
    }
    

    /**
     * @param mixed $last_check
     * @return Feed
     */
    public function setLastcheck($last_check)
    {
        $this->lastcheck = $last_check;
        return $this;
    }
    
    
    

}