$(document).ready(function () {
    "use strict";
    
    /* Стр. кампании пользователя */
    
    // Превьюшки:
    (function(){
        
        var
            $popupBg = $('.l-popup'),
            $popup = $('.b-popup__window.preview', $popupBg),
            $popupClose = $('.button-close', $popup),
            $popupInner = $('.b-popup-content', $popup),
            $popupMessage = $('.b-popup-message', $popup),
            $banners = $('.form-group.banners'),
            $tableBanners = $('table.campaign-banners', $banners);
        
        // Открываем попап:
        $tableBanners.on('click', '.banner-preview', function(){
            var
                $this = $(this),
                size = $.trim($('.banner-size', $this.parents('tr')).text()),
                data = {
                    id: $this.parents('tr').data('id'),
                    size: size.split('x'),
                    img: $this.attr('src')
                };
                
            ShowPopup(data);
        });
        
        // Закрыввем попап по клику на Х:
        $popupClose.on('click', function(){
            ClosePopup();
        });
        // Закрыввем попап по клику извне:
        $popup.on('click', function(event){
            event.stopPropagation();
        });
        $popupBg.on('click', function(){
            ClosePopup();
        });
        
        function ShowPopup(data)
        {
            var $content = $(document.createElement('div'));
            $content.append('<h2>id: <b>'+ data.id +'</b> <span>('+ data.size[0] +'х'+ data.size[1] +')</span></h2>');
            $content.append('<div class="banner-img"><img width="' + data.size[0] + '" height="' + data.size[1] + '" src="' + data.img + '" /></div>');
            
            $popupInner.append($content)
            
            $popupBg.addClass('open-popup');
            $popup.show();
        }
        
        function ClosePopup()
        {
            $popupBg.removeClass('open-popup');
            $popupMessage.hide();
            $popup.hide();
            $popupInner.empty();
        }
        
        
    })();
    
    // Статистика по кампании:
    (function(){
        
        var
            dataStat, dataStatTotal,
            $statWrap = $('.campaign-stat'),
            $statInfo = $('.chart-graph-stat-info', $statWrap),
            $statError = $('.chart-graph-stat-error', $statWrap),
            selectorStatChart = '#chart-graph-stat',
            $statChart = $(selectorStatChart, $statWrap),
            $statTable = $('.b-table_wrapp.report', $statWrap),
            $tableCampaignStat = $('#table-line', $statTable),
            targetActionValue = $('input[name=target_action]:checked').val(),
            chart,
            activeLine,
            activeLines,
            currencyFields = ['money'];
        
        // Добавление впереди 0 у однозначных значений
        function pad(number) {
            var r = String(number);
            if ( r.length === 1 ) {
              r = '0' + r;
            }
            return r;
        }
        
        // Форматирование даты
        function formatDate(date)
        {
            return date.getFullYear() +'-'+ pad(date.getMonth()+1) +'-'+ pad(date.getDate());
        }
        
        function valueFormat(value, ratio, id)
        {
            var
                dataLine = activeLines[parseInt(id.replace('data', '')) - 1],
                isCurrencyValue = currencyFields.indexOf(dataLine) > -1,
                format = (isCurrencyValue) ? d3.format(',.2f') : d3.format(',.0f');

            if (dataLine == 'OrderSum') {
                format = d3.format(',.0f');
            }

            if (parseFloat(format(value)) == 0 && value != 0) {
                var accuracy = Math.abs(Math.floor(Math.log10(value)));
                return value.toFixed(accuracy);
            }

            if (isCurrencyValue) {
                return format(value) + ' грн.';
            } else {
                return format(value);
            }
        }

        function valueFormatTick(value)
        {
            var
                isCurrencyValue = currencyFields.indexOf(activeLine) > -1,
                format = (isCurrencyValue) ? d3.format(',.2f') : d3.format(',.0f');

            return format(value);
        }

        
        // Получение данных для отрисовки графика Stat при старте:
        if ($('#campaign-stat').val() && $('#campaign-stat-total').val()) {
            dataStat = JSON.parse($('#campaign-stat').val());
            dataStatTotal = JSON.parse($('#campaign-stat-total').val());
        } else {
            ShowError();
        }
        
        console.log('AAA dataStat = ', dataStat);
        console.log('AAA dataStatTotal = ', dataStatTotal);
        
        function ShowInfo()
        {
            $statInfo.show();
            $statError.hide();
            $statChart.hide();
            $statTable.hide();
        }

        function ShowError()
        {
            $statError.show();
            $statInfo.hide();
            $statChart.hide();
            $statTable.hide();
        }
        
        function getCheckedCategories() {
            var listCats = [];
            $('thead th input[type="checkbox"]', $tableCampaignStat).each(function(){
                if ($(this).is(":checked")) {
                    listCats.push($(this).data('field'));
                }
            });
            return listCats;
        }
        
        function renderChart() {
            
            var
                dataPeriod = dataStat['period'],
                rotateX = null,
                formatTimeX = '%m-%d',
                selectedCategoriesId;

            var
                dataColumnsTemp = [['x'].concat(dataPeriod)],
                names = {},
                types = {},
                axes = {},
                colors = {};

            // Определяем выбранные категории для графика:
            selectedCategoriesId = getCheckedCategories();

            console.log('AAA renderChart selectedCategoriesId', selectedCategoriesId);
            
            // Скрываем график, если в таблице не выбраны категории:
            if (selectedCategoriesId.length == 0) {
                $statChart.hide();
                return false;
            } else {
                $statChart.show();
            }

            console.log('AAA activeLines = ', activeLines);
            
            var i = 0;
            Object.keys(activeLines).forEach(function(activeLineItem){
                if (selectedCategoriesId.indexOf(activeLineItem) > -1) {
                    i++;
                    dataColumnsTemp.push(['data'+i].concat(dataStat[activeLineItem]));
                    names['data'+i] = activeLines[activeLineItem]['title'];
                    types['data'+i] = 'area-spline';
                    axes['data'+i] = 'y';
                    colors['data'+i] = activeLines[activeLineItem]['color'];
                }
            });
            
            console.log('AAA dataColumnsTemp ', dataColumnsTemp);
            
            chart = c3.generate({
                bindto: selectorStatChart,
                data: {
                    x: 'x',
                    columns: dataColumnsTemp,
                    names: names,
                    types: types,
                    axes: axes,
                    colors: colors,
                },
                axis: {
                    x: {
                        type: 'timeseries',
                        categories: dataPeriod,
                        padding: {left: 0},
                        tick: {
                            culling: {max: 25},
                            format: formatTimeX,
                            rotate: rotateX
                        }
                    },
                    y: {
                        min: 0,
                        padding: {top: 50, bottom: 0},
                        tick: {
                            format: valueFormatTick
                        }
                    }
                },
                grid: {
                    x: {show: true},
                    y: {show: true},
                },
                tooltip: {
                    format: {
                        title: formatDate,
                        value: valueFormat
                    }
                },
                legend: {
                    show: true,
                    item: {
                        onclick: function (id) {
                            //toggleData(chart, id);
                        }
                    }
                },
            });

            // Подсвечиваем Определяем индексы воскресенья:
            dataPeriod.forEach(function(date, ind) {
                if ((new Date(date)).getUTCDay() == 0) {
                    $('.c3-axis.c3-axis-x .tick').eq(ind).attr('class', 'tick sunday');
                }
            });
            
            //chart.toggle(toggelDates);
            
        };
        
        function renderTable() {
            console.log('AAA renderTable');
        };
        
        switch(targetActionValue) {
            case 'load':
                activeLine = 'views';
            break;
            case 'view':
                activeLine = 'views';
            break;
            case 'click':
                activeLine = 'clicks';
            break;
        }
        
        activeLines = JSON.parse($('#campaign-stat-cats').val());
        
        if (dataStat) {
            // Отрисовка графика и таблицы по стартовым данным:
            if (dataStat.status == 'Error') {
                ShowError();
            } else {
                renderChart();
                renderTable();
            }
        } else {
            ShowInfo();
            $statChart.hide();
            $statTable.hide();
        }
        
        // Клик на checkbox в названии поля таблицы:
        var $tableHeadColsChecks = $('thead th input[type="checkbox"]', $tableCampaignStat);
        $tableHeadColsChecks.on('change', function(){
            renderChart();
        });
        
        
    })();
});

