$(document).ready(function(){
    
    (function(){
    
    })();
            
    // Выбор дат для Stat http://t1m0n.name/air-datepicker/docs/index-ru.html
    var
        nowDate = new Date(),
        datepicker1 = $('#date-value-1').datepicker({
            dateFormat: "yyyy-mm-dd",
            autoClose: true,
            maxDate: nowDate
        }).data('datepicker'),
        datepicker2 = $('#date-value-2').datepicker({
            dateFormat: "yyyy-mm-dd",
            autoClose: true,
            maxDate: nowDate
        }).data('datepicker'),
        $chartStat = $('#chart-graph-stat'),
        $chartTable = $('#table-stat'),
        $chartStatInfo = $('.chart-graph-stat-info'),
        $chartStatError = $('.chart-graph-stat-error'),
        $chartStatLoading = $('.chart-graph-stat-loading'),
        $chartStatErrorMessage = $('.chart-graph-stat-error .message'),
        periodStatsData,
        companyStatsData,
        dataLineChartStat;
        
    // Установка стартовых значений дат:
    //datepicker1.selectDate(new Date($('#date-value-1').val()));
    //datepicker2.selectDate(new Date($('#date-value-2').val()));
    
    // Получение данных для отрисовки графика Stat при старте:
    if ($('#period-stats').val()) {
        periodStatsData = JSON.parse($('#period-stats').val());
    }
    if ($('#company-stats').val()) {
        companyStatsData = JSON.parse($('#company-stats').val());
    }
    // Устанавливаем данные по периоду в качестве стартовых:
    dataLineChartStat = periodStatsData;
    
    //console.log('AAA dataLineChartStat = ', dataLineChartStat);
    
    // Отрисовка графика и таблицы по стартовым данным:
    renderLineChart();
    renderHourTable();
    
    // Смена периода:
    $('.form-control.stat-period').on('change', function(){
        var period = $(this).val();
        // Установка значений периода в дате:
        switch(period) {
            case 'today':
                datepicker1.selectDate(nowDate);
                datepicker2.selectDate(nowDate);
            break;
            case 'yesterday':
                var yesterdayDate = new Date();
                yesterdayDate.setDate(yesterdayDate.getDate()-1);
                datepicker1.selectDate(yesterdayDate);
                datepicker2.selectDate(yesterdayDate);
            break;
            case '7days':
                var prev7day = new Date();
                prev7day.setDate(prev7day.getDate()-7);
                datepicker1.selectDate(prev7day);
                datepicker2.selectDate(nowDate);
            break;
            case '30days':
                var prev30day = new Date();
                prev30day.setDate(prev30day.getDate()-30);
                datepicker1.selectDate(prev30day);
                datepicker2.selectDate(nowDate);
            break;
            case 'current_month':
                var firstDay = new Date(nowDate.getFullYear(), nowDate.getMonth(), 1);
                datepicker1.selectDate(firstDay);
                datepicker2.selectDate(nowDate);
            break;
            case 'prev_month':
                var firstDay = new Date(nowDate.getFullYear(), nowDate.getMonth()-1, 1);
                var lastDay = new Date(nowDate.getFullYear(), nowDate.getMonth(), 0);
                datepicker1.selectDate(firstDay);
                datepicker2.selectDate(lastDay);
            break;
            case 'year':
                var firstDay = new Date(nowDate.getFullYear(), 0, 1);
                datepicker1.selectDate(firstDay);
                datepicker2.selectDate(nowDate);
            break;
            default:
                datepicker1.clear();
                datepicker2.clear();
            break;
        }
    });
    
    // Сортировка по колонкам внутри таблицы:
    $('#table-line').on('click', 'thead.metric.sortable th b', function(){
        var
            $this = $(this);
        
        $('#table-line thead.metric.sortable th b').removeClass('selected');
        $this.addClass('selected');
        $this.toggleClass('desc');

        if ($this.hasClass('main-cat')) {
            if ($this.hasClass('date')) {
                dataLineChartStat = periodStatsData;
            } else {
                dataLineChartStat = companyStatsData;
            }
        }
        renderHourTable();

    });
    
    // Клик на checkbox в названии поля таблицы:
    $('#table-line').on('change', 'thead.metric.sortable th input[type="checkbox"]', function(){
        renderLineChart();
    });
    
    // Отрисовка графика Stat
    function renderLineChart()
    {
        if(dataLineChartStat && $chartStat.length>0) {
            $.ChartStat.DateStat(dataLineChartStat);
            return false;
        }
    }
    
    $chartTable.show();
    
    // Отрисовка почасовой таблицы
    function renderHourTable()
    {
        if(dataLineChartStat) {
            $.TableStat.Render(dataLineChartStat);
            $chartTable.show();
        } else {
            $chartTable.hide();
        }     
    }
    
    
});