<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Entity;

/**
 * Class Slot
 * @package App\Entity
 */
class Slot extends Common
{

    /**
     * @return string
     */
    public function getSiteId()
    {
        return $this->siteId;
    }
    
    /**
     * @param string $siteId
     * @return Slot
     */
    public function setSiteId($siteId)
    {
        $this->siteId = $siteId;
        return $this;
    }
    
    /**
     * @return int
     */
    public function getDisabled()
    {
        return $this->disabled;
    }

    /**
     * @param int $is_disabled
     * @return Slot
     */
    public function setDisabled($is_disabled)
    {
        $this->disabled = $is_disabled;
        return $this;
    }
    
    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    
    /**
     * @param string $name
     * @return Slot
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }
    
    /**
     * @return string
     */
    public function getNode()
    {
        return $this->node;
    }
    
    /**
     * @param string $node
     * @return Slot
     */
    public function setNode($node)
    {
        $this->node = $node;
        return $this;
    }
    
    /**
     * @return string
     */
    public function getOffset()
    {
        return $this->offset;
    }
    
    /**
     * @param string $offset
     * @return Slot
     */
    public function setOffset($offset)
    {
        $this->offset = $offset;
        return $this;
    }
    
    /**
     * @return string
     */
    public function getMargin()
    {
        return $this->margin;
    }
    
    /**
     * @param string $margin
     * @return Slot
     */
    public function setMargin($margin)
    {
        $this->margin = $margin;
        return $this;
    }
    
    /**
     * @return int
     */
    public function getSyncheight()
    {
        return $this->syncheight;
    }

    /**
     * @param int $is_syncheight
     * @return Slot
     */
    public function setSyncheight($is_syncheight)
    {
        $this->syncheight = $is_syncheight;
        return $this;
    }
    
    /**
     * @return int
     */
    public function getClearbefore()
    {
        return $this->clearbefore;
    }

    /**
     * @param int $is_clearbefore
     * @return Slot
     */
    public function setClearbefore($is_clearbefore)
    {
        $this->clearbefore = $is_clearbefore;
        return $this;
    }
    
    /**
     * @return string
     */
    public function getHalign()
    {
        return $this->halign;
    }
    
    /**
     * @param string $halign
     * @return Slot
     */
    public function setHalign($halign)
    {
        $this->halign = $halign;
        return $this;
    }
    
    
    /**
     * @return string
     */
    public function getStyles()
    {
        return $this->styles;
    }
    
    /**
     * @param string $styles
     * @return Slot
     */
    public function setStyles($styles)
    {
        $this->styles = $styles;
        return $this;
    }
    
    /**
     * @return string
     */
    public function getAddstyles()
    {
        return $this->addstyles;
    }
    
    /**
     * @param string $addstyles
     * @return Slot
     */
    public function setAddstyles($addstyles)
    {
        $this->addstyles = $addstyles;
        return $this;
    }
    
    /**
     * @return string
     */
    public function getZones()
    {
        return $this->zones;
    }
    
    /**
     * @param string $zones
     * @return Slot
     */
    public function setZones($zones)
    {
        $this->zones = $zones;
        return $this;
    }
    
    /**
     * @return string
     */
    public function getFixed()
    {
        return $this->fixed;
    }
    
    /**
     * @param string $fixed
     * @return Slot
     */
    public function setFixed($fixed)
    {
        $this->fixed = $fixed;
        return $this;
    }
    
    /**
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }
    
    /**
     * @param string $comment
     * @return Slot
     */
    public function setComment($comment)
    {
        $this->comment = $comment;
        return $this;
    }
    
}