
const SiteAPI = {
    sites: [
        { id: 1, domain: "Sinoptik", info: "info-text" },
        { id: 2, domain: "Ukrnet", info: "info-text" },
        { id: 3, domain: "Alpha", info: "info-text" },
        { id: 4, domain: "Bravo", info: "info-text" },
        { id: 5, domain: "Charlie", info: "info-text" },
        { id: 6, domain: "Dendy", info: "info-text" }
    ],
    all: function() { return this.sites},
    get: function(id) {
        const isSite = site => site.id === id;
        return this.sites.find(isSite)
    }
}


const ListSites = () => (
    <div>
        <ul>
            {
            SiteAPI.all().map(site => (
                <li key={site.id}>
                    <Link to={`/sites/${site.id}`}>{site.domain}</Link>
                </li>
            ))
            }
        </ul>
    </div>
)


const SiteItem = (props) => {
    const site = SiteAPI.get(
        parseInt(props.match.params.id, 10)
    )
    if (!site) {
      return <div>Sorry, but the site was not found</div>
    }
    return (
      <div>
        <h1>{site.domain} (#{site.id})</h1>
        <h2>Info: {site.info}</h2>
        <Link to='/sites'>Back</Link>
      </div>
    )
}

const SitesList = () => (
    <div>
        <h2>This is a site page!</h2>
        <Switch>
            <Route exact path='/sites' component={ListSites}/>
            <Route path='/sites/:id' component={SiteItem}/>
        </Switch>
    </div>    
)

