/*
    Service
*/

class Service extends React.Component {
    render() {
        return (
            <div className="form-group service">
                <div className="form-group-title">Сервисные параметры:</div>
                <div className="services">
                    <input type="checkbox" id="only_native" name="onlyNative" onChange={() => this.props.onServiceChange("onlyNative")} checked={this.props.service.onlyNative} />&nbsp;
                    <label htmlFor="only_native">только тизеры</label>
                    <input type="checkbox" id="forced_start" name="forcedStart" onChange={() => this.props.onServiceChange("forcedStart")} checked={this.props.service.forcedStart} />&nbsp;
                    <label htmlFor="forced_start">принудительный старт</label>
                    <input type="checkbox" id="pay_block" name="payBlock" onChange={() => this.props.onServiceChange("payBlock")} checked={this.props.service.payBlock} />&nbsp;
                    <label htmlFor="pay_block">платный обход блоков</label>
                    <input type="checkbox" id="only_goods" name="onlyGoods" onChange={() => this.props.onServiceChange("onlyGoods")} checked={this.props.service.onlyGoods} />&nbsp;
                    <label htmlFor="only_goods">только товары</label>
                </div>
                <ClearBoth />
            </div>
        );
    }
}


function mapStateToProps(state) {
    return {
        service: state.service
    }
}

function matchDispatchToProps(dispatch) {
    return bindActionCreators({onServiceChange: onServiceChange}, dispatch);
}

const ConnectedService = connect(mapStateToProps, matchDispatchToProps)(Service);
