/*
    Zones
*/

class Zones extends React.Component {
    showZonesList = () => {
        return this.props.zones.map((item, i) => {
            return (
                <ZoneItem key={item.id} index={i} data={item} deleteZone={(data) => this.props.deleteZone(data)} editZone={(data) => this.props.editZone(data)} />
            )
        })
    };
    render() {
        if (this.props.zones) {
            return (
                <div className="form-group zone">
                    <div className="form-group-title">Зоны (zones):</div>
                    <div className="zones">
                        <input className="form-control" type="hidden" id="zones" name="zones" defaultValue="" />
                        {this.showZonesList()}
                    </div>
                    <div>
                        <div className="btn-group">
                            <a role="button" className="btn btn-primary add-zone" href="#" onClick={(event) => this.props.addZone(event)}>Добавить зону</a>
                        </div>
                    </div>
                </div>    
            );  
        } else {
            return (
                <div className="form-group slot">
                    <div className="form-group-title">Слоты (slots):</div>
                    <ClearBoth />
                </div>
            );  
        }
    }
}


function mapStateToProps(state) {
    return {
        zones: state.zones,
    }
}

function matchDispatchToProps(dispatch) {
    return bindActionCreators({addZone: addZone, deleteZone: deleteZone, editZone: editZone}, dispatch);
}

const ConnectedZones = connect(mapStateToProps, matchDispatchToProps)(Zones);
