<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Middleware;


use App\Entity\LayoutInfo as LayoutInfoEntity;
use App\Entity\Vacancies\Item;
use App\Model\Locales;
use App\Model\Vacancies\Items;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Zend\Expressive\Router\RouterInterface;
use \Zend\Permissions\Acl\AclInterface;
use Zend\View\Model\ViewModel;

class LayoutInfo
{

    /**
     * @var Items
     */
    protected $vacancies;

    /**
     * @var ViewModel
     */
    protected $layout;

    /**
     * @var Locales
     */
    protected $locales;

    /**
     * @var RouterInterface
     */
    protected $router;
    
    /**
     *
     * @var AclInterface
     */
    protected $acl;

    protected $phones;
    protected $mails;
    protected $skypes;

    /**
     * @param ServerRequestInterface $request
     * @param ResponseInterface $response
     * @param callable|null $next
     * @return mixed
     */
    public function __invoke(ServerRequestInterface $request, ResponseInterface $response, callable $next = null)
    {
        $info = new LayoutInfoEntity();


        $lang = strtolower($request->getAttribute('lang'));
        // if no allowed language in param -> use first locale lang as default
        $lang = in_array($lang, $this->locales->getLanguages()) ? $lang : $this->locales->getLanguages()[0];

        $info->setLang($lang);
        $info->setLocales($this->locales);

        $info->setPhones($this->phones);
        $info->setMails($this->mails);
        $info->setSkypes($this->skypes);

        $info->setRouter($this->router);
        $info->setFlash($request->getAttribute('flash'));
        $info->setRequest($request);
        $info->setAcl($this->acl);

        $info->enableLogin(array_key_exists('enablelogin', $request->getQueryParams()));


        $this->layout->setVariable('layoutInfo', $info);
        $request = $request->withAttribute('layoutInfo', $info);

        return $next($request, $response);
    }

    /**
     * Footer constructor.
     *
     * @param Items $vacancies
     * @param ViewModel $layout
     */
    public function __construct(ViewModel $layout, Locales $locales, RouterInterface $router, AclInterface $acl, array $phones, array $mails, array $skypes)
    {
        $this->layout = $layout;
        $this->locales = $locales;
        $this->router = $router;
        $this->acl = $acl;
        $this->phones = $phones;
        $this->mails = $mails;
        $this->skypes = $skypes;
    }
}