<?php
/**
 * Created by PhpStorm.
 * User: ferti
 * Date: 28.11.2016
 * Time: 19:22
 */

namespace App\Action\User;


use App\Action\Common;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;

/**
 * Action Login
 *
 * @package App\Action\User
 */
class Login extends Common
{
    /**
     * @param ServerRequestInterface $request
     * @param ResponseInterface $response
     * @param callable|null $next
     * @return ResponseInterface
     * @throws \Exception
     */
    public function __invoke(ServerRequestInterface $request, ResponseInterface $response, callable $next = null)
    {

        $data = [
            'email' => $request->getParsedBody()['email'] ?? null,
            'password' => $request->getParsedBody()['password'] ?? null,
            'remember_pass' => $request->getParsedBody()['remember-pass'] ?? null
        ];

        return  $this->authenticate($data, $request);
    }
}