$(document).ready(function () {
    "use strict";
    
    /* Стр. создания-редактирования группы кампаний */
    
    var
        $contentWrap = $('.b-content__work.inner'),
        isCreatePage = $('.group-id').data('id') == 0,
        $form = $('#group-create-form', $contentWrap),
        $userNewBlock = $('span.user-new', $form),
        isChanged = false,
        popupIsOpen = false,
        changeContriolsListenerIsActive = false,
        $checkTrackingAction = $('#group-tracking-action'),
        $btnSubmitAction = $('.btn.submit-action', $form),
        $btnCancelAction = $('.btn.cancel-action', $form);
    
    // Покидание страницы:
    window.onbeforeunload = function(e) {
        if (isChanged || popupIsOpen) {
            return "Данные не сохранены. Закрыть страницу без сохранения?";
        }
    };
    
    function CheckNullValueInput(value) {
        return ($.trim(value) != '') ? $.trim(value) : null;
    }
    
    function CheckFloatValueInput(value) {
        value = value.replace(',', '.');
        return (isNaN(parseFloat(value))) ? null : parseFloat(value);
    }
    
    function CheckBuyType() {
        var
            buyTypeValue = $('input[name=buy_type]:checked', $form).val(),
            targetActionValue = $('input[name=target_action]:checked', $form).val(),
            $targetActionLoad = $('input#campaign-view-load', $form),
            $targetActionLoadLabel = $('label[for="campaign-view-load"]', $form);
        
        if (buyTypeValue == 'auction') {
            $targetActionLoad.prop('disabled', true);
            $targetActionLoadLabel.addClass('disabled');
        } else {
            $targetActionLoad.prop('disabled', false);
            $targetActionLoadLabel.removeClass('disabled');
        }
        
        
        if (buyTypeValue == 'auction' && targetActionValue == 'load') {
            $('input#campaign-view-view', $form).prop('checked', true);
        }
    }
    
    function CheckTargetAction() {
        var
            targetActionValue = $('input[name=target_action]:checked', $form).val(),
            $priceTitleMark = $('.price-title-mark', $form),
            titleValue;
        
        switch(targetActionValue) {
            case 'load':
                titleValue = '1000 показов';
            break;
            case 'view':
                titleValue = '1000 реальных показов';
            break;
            case 'click':
                titleValue = 'клик';
            break;
        }
        $priceTitleMark.text(titleValue);
    }
    
    function CheckTrackingAction($check) {
        var
            $content = $('.tracking-action_content'),
            isChecked = $check.prop("checked");
    
        if (isChecked) {
            $content.show();
        } else {
            $content.hide();
        }
    }
    
    function dataChanged($target)
    {
        if (changeContriolsListenerIsActive) {
            isChanged = true;
            $btnCancelAction.attr('disabled',false);
            $btnSubmitAction.attr('disabled',false);
            
            var
                $formGroup = $target.parents('.form-group').eq(0),
                $label = $('label.title-field', $formGroup);

            $label.addClass('changed');
            
            // Название в header-панели
            if ($formGroup.hasClass('title')) {
                $target.siblings('.value-show').addClass('changed');
            }
        }
    }
    
    function AddListenerChangeContriols()
    {
        changeContriolsListenerIsActive = true;
        // Действие по какому-либо контролу:
        $form.on('change', 'input, select', function(){
            dataChanged($(this));
        });
        $form.on('keyup', 'input', function(){
            dataChanged($(this));
        });
        $('.panel-heading input.group-title').on('change', function(){
            dataChanged($(this));
        });
    }
    
    // Клик на редактируемый элемент (название группы):
    $contentWrap.on('click', '.edited', function(){
        var
            $field = $(this),
            fieldName = $field.data('field'),
            $input = $('input.'+fieldName, $field.parent()),
            oldVal = $input.val(),
            oldText = $field.html();
        
        $field.hide();
        $input.off('blur').off('keyup').show().focus();
        
        $input.on('keyup', function(e) {
            
            if (e.keyCode == 13) {
                $input.blur();
            }
            
            if (e.keyCode == 27) {
                $input.off('blur');
                $input.val(oldVal);
                $field.html(oldText);
                $input.hide();
                $field.show();
            }
           
        });
        $input.on('blur', function() {
            
            var
                textInput = $input.val(),
                textField = textInput;
            
            $input.hide();
            $field.html(textField);
            
            if (textInput != oldVal) {
                $field.addClass('was-edited');
                //MarkOfferAsEdited();
            }
            
            $field.show();
        });
    });
    
    // Переключение типа кампании:
    $('input[name=buy_type]', $form).on('change', function(){
       CheckBuyType();
    });
    CheckBuyType();
    
    // Переключение целевого действия:
    $('input[name=target_action]', $form).on('change', function(){
       CheckTargetAction();
    });
    CheckTargetAction();
    
    // Клик на галочку Трекинг действий:
    $checkTrackingAction.on('change', function(e) {
        CheckTrackingAction($(this));
    });
    CheckTrackingAction($checkTrackingAction);
    
    
    // Переключение смены пользователя:
    $('select#group-user-id', $form).on('change', function(){        
        if ($(this).val() == 'new') {
            $userNewBlock.show();
        } else {
            $userNewBlock.hide();
        }
    });
    
    // Редактирование элементов формы:
    (function(){
        
        var
            $popupBg = $('.l-popup'),
            $popupEdit = $('.b-popup__window.edit', $popupBg),
            $popupInner = $('.b-popup-inner', $popupEdit),
            $popupClose = $('.button-close', $popupEdit),
            $popupTitle = $('.b-popup-content h1', $popupEdit),
            $saveBtn = $('.btn.save-edit', $popupEdit),
            $cancelBtn = $('.btn.cancel-edit', $popupEdit);
        
        // Склонение числительных
        function declOfNum(number, titles) {
            var cases = [2, 0, 1, 1, 1, 2];
            return titles[ (number%100 > 4 && number %100 < 20) ? 2 : cases[Math.min(number%10, 5)] ];
        }
        
        function ChangeEditValue($formGroup) {

            var
                type = $formGroup.data('type'),
                $valueShow = $('.value-show', $formGroup),
                $valueEdit = $('.value-edit', $formGroup),
                content = '';

            if (type == 'title') {
                content = $('input', $valueEdit).val();
            }
            if (type == 'url') {
                content = $('input', $valueEdit).val();
            }
            if (type == 'visitor-limit') {
                $('.campaign-visitor-limit input', $valueEdit).each(function(){
                    var
                        $this = $(this),
                        itemVal = parseInt($this.val());

                    if (itemVal) {
                        var titles = ($this.parent().hasClass('view')) ? ['показ', 'показа', 'показов'] : ['клик', 'клика', 'кликов'];
                        content += '<span><b>' + itemVal + '</b> <i>' + declOfNum(itemVal, titles) + '</i> ' + $this.data('desc') + '</span><br />';
                    }
                });
            }
            if (type == 'money-limit') {
                $('input', $valueEdit).each(function(){
                    var
                        $this = $(this),
                        itemVal = CheckFloatValueInput($this.val());

                    if (itemVal) {
                        var titles = 'грн.';
                        content += '<span><b>' + itemVal + '</b> ' + titles + ' ' + $this.data('desc') + '</span><br />';
                    }
                });
            }
            if (type == 'geo') {
                var
                    countryVal = $('.geo_country select option:selected', $valueEdit).text(),
                    regionItems = [],
                    cityItems = [],
                    regionVal = '',
                    cityVal = '';

                if ($('.geo_country select', $valueEdit).val() == 'UA' && $('.geo_country .b-exclude input').is(':checked')) {
                    countryVal += ' (исключить неподконтрольные территории)';
                }

                content += '<span>Страна: <b>' + countryVal + '</b></span><br />';

                $('.geo_region .filters-values ul li input', $valueEdit).each(function(){
                    regionItems.push($(this).data('text').replace(' область', ''));
                });
                if (regionItems.length > 0) {
                    regionVal += ($('.geo_region .b-exclude input', $valueEdit).is(':checked')) ? '<i>кроме:</i> ' : '<i>только:</i> ';
                    regionVal += '<b>' + regionItems.join(', ') + '</b>';
                    content += '<span>Области ' + regionVal + '</span><br />';
                }

                $('.geo_city .filters-values ul li input', $valueEdit).each(function(){
                    cityItems.push($(this).data('text'));
                });
                if (cityItems.length > 0) {
                    cityVal += ($('.geo_city .b-exclude input', $valueEdit).is(':checked')) ? '<i>кроме:</i> ' : '<i>только:</i> ';
                    cityVal += '<b>' + cityItems.join(', ') + '</b>';
                    content += '<span>Города ' + cityVal + '</span><br />';
                }

                var
                    geoData = {},
                    countryValue,
                    countryExclude,
                    regionValues = [],
                    regionExclude,
                    cityValues = [],
                    cityExclude,
                    isGeoSet;

                // country
                countryValue = $('select#targeting_geo_country', $formGroup).val();
                countryExclude = ($('input#country-exclude', $formGroup).is(':checked')) ? true : false;
                geoData['country'] = {
                    values: [countryValue],
                    exclude: false
                };

                // special
                if (countryValue == 'UA' && countryExclude) {
                    geoData['special'] =  {
                        values: ["ATO", "Crimea"],
                        exclude: true
                    }
                }

                // region
                $('.geo_region .filters-values ul li', $formGroup).each(function(){
                    regionValues.push(parseInt($('input', $(this)).data('id')));
                });
                regionExclude = ($('input#region-exclude', $formGroup).is(':checked')) ? true : false;
                geoData['region'] = {
                    values: regionValues,
                    exclude: regionExclude
                };

                // city
                $('.geo_city .filters-values ul li', $formGroup).each(function(){
                    cityValues.push(parseInt($('input', $(this)).data('id')));
                });
                cityExclude = ($('input#city-exclude', $formGroup).is(':checked')) ? true : false;
                geoData['city'] = {
                    values: cityValues,
                    exclude: cityExclude
                };

                if ((countryValue == 'UA' && countryExclude) && regionValues.length == 0 && regionValues.length == 0) {
                    isGeoSet = false;
                } else {
                    isGeoSet = true;
                }

                if (isGeoSet) {
                    $formGroup.attr('data-value', JSON.stringify({geo: geoData}))
                } else {
                    $formGroup.attr('data-value', null)
                }

            }
            if (type == 'tracking-pixels') {

                var
                    dataTrackingPixels = {},
                    isTrackingPixelsSet = false;

                $('.tracking_pixels_item', $formGroup).each(function(){

                    var
                        $this = $(this),
                        name = $this.data('name'),
                        dataValues = [],
                        noItems = true,
                        inputValue;

                    $('.tracking_pixels_urls input', $this).each(function(){
                        var $input = $(this);
                        if ($input.val()) {
                            isTrackingPixelsSet = true;
                            if (noItems) {
                                content += '<div>' + $('label', $this).text() + '</div>';
                                noItems = false;
                            }
                            inputValue = $.trim($input.val());
                            content += '<div class="url">' + inputValue + '</div>';
                            dataValues.push(inputValue);
                        }
                    });

                    dataTrackingPixels[name] = dataValues;
                });
                if (isTrackingPixelsSet) {
                    $formGroup.attr('data-value', JSON.stringify(dataTrackingPixels))
                } else {
                    $formGroup.attr('data-value', null)
                }

            }
            $valueShow.empty();
            $valueShow.append(content);

        }
        
        function AddEditPopupEventsListener() {
            // Закрыввем попап по клику на Х:
            $popupClose.on('click', function(){
                ClosePopupEdit();
            });
            // Закрыввем попап по клику извне:
            /*
            $popupEdit.on('click', function(event){
                event.stopPropagation();
            });
            $popupBg.on('click', function(){
                ClosePopupEdit();
            });
            */
            AddControlsEventsListener();
        }
        
        function RemoveEditPopupEventsListener() {
            $popupClose.off('click');
            $popupEdit.off('click');
            $popupBg.off('click');
        }
        
        function ShowPopupEdit(type, title, data)
        {
            popupIsOpen = true;
            $saveBtn.attr('disabled', true);
            InsertPopupEdit(title, data);
            $popupBg.addClass('open-popup');
            $popupEdit.show();
            $popupEdit.attr('data-type', type);
            AddEditPopupEventsListener();
        }
        
        function ClosePopupEdit()
        {
            popupIsOpen = false;
            $popupBg.removeClass('open-popup');
            $popupEdit.hide();
            $popupInner.empty();
            RemoveEditPopupEventsListener();
        }
        
        function InsertPopupEdit(title, data)
        {
            
            $popupTitle.text(title);
            $popupInner.append(data);
        }

        function AddControlsEventsListener()
        {
            // Действие по какому-либо контролу внутри попапа:
            $('input, select', $popupInner).on('change', function(){
                $saveBtn.attr('disabled', false);
            });
            $('input', $popupInner).on('keyup', function(){
                $saveBtn.attr('disabled', false);
            });
            
            // Добавление/удаление tracking_pixels urls
            (function(){
                
                $popupEdit.on('click', '.tracking_pixels_item .add-row', function(){
                    var
                        $this = $(this),
                        $trackingItem = $this.parents('.tracking_pixels_item'),
                        $urlsWrap = $('.tracking_pixels_urls', $trackingItem);
                    $urlsWrap.append('<div class="url-item"><input type="text" class="form-control" value="" placeholder="url"><div class="delete-item">×</div></div>');
                });
                $popupEdit.on('click', '.tracking_pixels_urls .delete-item', function(){
                    $(this).parent().remove();
                });
                
            })();
            
            // Гео
            (function(){
            
                var
                    $geoCountrySelect = $('.form-control#targeting_geo_country', $popupEdit),
                    $geoWrap = $('.targeting_geo', $popupEdit);
            
                // Изменение значения страны
                $geoCountrySelect.on('change', function(){
                    var $geoCountryExclude = $('.geo_country .b-exclude', $popupEdit);
                    if ($(this).val() == 'UA') {
                        $geoCountryExclude.show();
                    } else {
                        $geoCountryExclude.hide();
                    }
                });
                
                // Изменение списка фильтров чекбоксом:
                $geoWrap.on('change', '.geo_region-city .list-filter input',function(){

                    var
                        $this = $(this),
                        $listItems = $('li', $this.parents('ul')),
                        $listString = $('.values-string-list', $this.parents('.form-group')[0]),
                        values = [],
                        tplId = ($this.parents('.geo_region').length) ? 'l-region-id-' : 'l-city-id-';

                    $this.attr('checked', $this.is(':checked'));

                    $listItems.each(function(){
                        var
                            $this = $(this),
                            $checkbox = $('input', $this);

                        if ($checkbox.is(':checked')) {
                            values.push([$checkbox.data('id'), $checkbox.data('text')]);
                        }
                    });

                    // Редактируем список выбранных фильтров справа:
                    $listString.empty();
                    if (values.length > 0) {
                        values.forEach(function(valuesItem) {
                            $listString.append('<li><input type="checkbox" checked id="' + tplId + valuesItem[0] + '" data-id="' + valuesItem[0] + '" data-text="' + valuesItem[1] + '"> <label for="' + tplId + valuesItem[0] + '">' + valuesItem[1] + '</label></li>');
                        });
                    }
                    //$listString.trigger('change-list');

                });

                // Удаление из списка фильтров снятием галочки:
                $geoWrap.on('change', '.geo_region-city .values-string-list input',function(){
                    var
                        itemId = $(this).data('id'),
                        $listFilterItem = $('.list-filter input[data-id="' + itemId + '"]', $(this).parents('.form-group'));

                    $listFilterItem.attr('checked', false);
                    $listFilterItem.change();
                });

                // Изменение фильтрации внутри фильтра:
                $geoWrap.on('keyup', '.geo_region-city input.filter',function(){
                    var
                        $this = $(this),
                        val = $this.val().toLowerCase(),
                        $listItems = $('li', $this.parents('.filters-select'));


                    // Фильтрация списка значений:
                    $listItems.each(function(){
                        var
                            $item = $(this),
                            itemTitle = $('input', $item).data('text').toLowerCase(),
                            filteredByVal = itemTitle.indexOf(val) == 0;

                        $item.hide().removeClass('filtered');
                        if (filteredByVal) {
                            $item.show().addClass('filtered');
                        }
                    });

                });
                
            })();
            
        }

        // Клик на "Правка" для блока
        $('.form-group').on('click', '.edit-item', function(){
            var
                $this = $(this),
                $formGroup = $this.parents('.form-group').eq(0),
                typeGroup = $formGroup.data('type'),
                $valueEdit = $('.value-edit', $formGroup),
                titleGroup = $('label.title-field', $this.parent()).text();

            $formGroup.attr('data-tempstate', $valueEdit.html());

            ShowPopupEdit(typeGroup, titleGroup, $valueEdit.html());
            
            return false;
        });

        // Клик на "Сохранить" значение блока
        $saveBtn.on('click', function(){
            var
                type = $popupEdit.attr('data-type'),
                $formGroup = $('.form-group[data-type="' + type + '"]'),
                $valueEdit = $('.value-edit', $formGroup);
                
            $formGroup.attr('data-tempstate', null);
            
            $('input', $popupEdit).each(function(){
                var $this = $(this);
                $this.attr("value", $.trim($this.val()));
            });
           
            $valueEdit.html($popupInner.html());
            
            ChangeEditValue($formGroup);
           
            ClosePopupEdit();
            dataChanged($valueEdit);
            return false;
        });

        // Клик на "Отменить" редактирование блока
        $cancelBtn.on('click', function(){
            var
                type = $popupEdit.attr('data-type'),
                $formGroup = $('.form-group[data-type="' + type + '"]'),
                $valueEdit = $('.value-edit', $formGroup);
                
            $valueEdit.html($formGroup.attr('data-tempstate'));
            $formGroup.attr('data-tempstate', null);

            ClosePopupEdit();
            return false;
        });

        // Устанавливаем стартовые значения блоков формы
        $('.form-group[data-type]').each(function(){
            ChangeEditValue($(this));
        });
        
    })();
    
    // Фокус на название и раскрытие блоков при создании новой группы кампаний:
    if (isCreatePage) {
        $('.form-control.group-title.create').focus();
        $btnCancelAction.attr('disabled', false);
    }
    AddListenerChangeContriols();
    
    // Клик на галочку "Активности камапнии" на стр. списка кампаний:
    $('.table.campaigns').on('change', 'input.is-active', function(e) {
        
        var
            $this = $(this),
            campaignId = $this.data('id'),
            $campaignTr = $this.parents('tr'),
            isActive = $this.prop("checked"),
            action = $this.parents('table').data('action').replace('id',campaignId),
            method = 'POST',
            data = {
                'toggle_active': 1,
                'is_active': isActive ? 1 : 0,
            };
        
        $this.prop("disabled", true);
        
        $.ajax(action, {
            type: method,
            data: data,
            success: function(data) {
                $this.prop("disabled", false);
                
                if (data.result) {
                    if (isActive) {
                        $campaignTr.removeClass('disabled');
                    } else {
                        $campaignTr.addClass('disabled');
                    }
                }
            },
            error: function(rew, status, err) {
                console.log(status, err);
                $this.prop("disabled", false);
            }
        });
        
    });
    
    // Форма создания-редактирования группы Клик на "Сохранить":
    $btnSubmitAction.on('click', function(e) {
        
        if ($(this).attr('disabled') == 'disabled') return false;
        
        isChanged = false;
        
        e.stopPropagation();
        
        var
            action = $form.attr('action'),
            method = $form.attr('method'),
            data = {},
            warningInfo = null;
        
        // Основные данные для страниц создания и редактирования:
        data['active'] = ($('input#group-active', $form).is(':checked')) ? 1 : 0;
        data['buy_type'] = $('input[name=buy_type]:checked', $form).val();
        data['target_action'] = $('input[name=target_action]:checked', $form).val();
        data['price'] = CheckFloatValueInput($('input#campaign-price', $form).val());
        data['max_speed'] = $('input[name=max_speed]:checked', $form).val();
        data['targeting'] = $('.form-group.geo', $form).attr('data-value');
        
        if ($checkTrackingAction.prop("checked")) {
            data['tracking_action'] = 1;
            data['order_sum'] = CheckFloatValueInput($('input#campaign-order-sum', $form).val());
        } else {
            data['tracking_action'] = 0;
            data['order_sum'] = null;
        }
        
        data['user_id'] = $('select#group-user-id', $form).val();
        if (data['user_id'] == 'new') {
            data['user_name'] = CheckNullValueInput($('input#user-name', $form).val());
            data['user_email'] = CheckNullValueInput($('input#user-email', $form).val());
            
            // Проверка email пользователя на уже имеющегося в системе:
            if (data['user_email']) {
                $('select#group-user-id option', $form).each(function(){
                    var $this = $(this);
                    if (data['user_email'] == $this.data('email')) {
                        warningInfo = 'Пользователь с введенным email уже в системе присутствует';
                    }
                });
            }
        }
        
        var
            visitorLimit = {},
            isVisitorLimitSet = false;
        $('.form-group.campaign-visitor-limit__wrap .value-edit .campaign-visitor-limit').each(function(){
            var
                $this = $(this),
                dataLimit = {};

            $('input', $this).each(function(){
                var $input = $(this);
                if (parseInt($input.attr('value'))) {
                    isVisitorLimitSet = true;
                    dataLimit[$input.attr('name')] = parseInt($input.attr('value'));
                } else {
                    dataLimit[$input.attr('name')] = 0;
                }
            });
            visitorLimit[$this.data('name')] = dataLimit;
        });
        if (isVisitorLimitSet) {
            data['visitor_limit'] = JSON.stringify(visitorLimit);
        } else {
            data['visitor_limit'] = null;
        }
        
        
        // Данные для стр. создания:
        if (isCreatePage) {
            
            data['title'] = CheckNullValueInput($('input.group-title', $form).val());
            
            var
                totalValue = CheckFloatValueInput($('input#campaign-money-limit-total', $form).val()),
                dataMoneyLimit = {
                    total: totalValue,
                    day: 0,
                    week: 0,
                    month: 0,
                };
            if (totalValue) {
                data['money_limit'] = JSON.stringify(dataMoneyLimit);
            } else {
                data['money_limit'] = null;
            }
        }
        
        // Данные для стр. редактирования:
        if (!isCreatePage) {
            
            data['title'] = CheckNullValueInput($('.panel-heading input.group-title').val());
            
            var
                moneyLimit = {},
                isMoneyLimitSet = false;
            $('.form-group.campaign-money-limit .value-edit input').each(function(){
                var $this = $(this);
                
                if (parseFloat($this.attr('value'))) {
                    isMoneyLimitSet = true;
                    moneyLimit[$this.attr('name')] = CheckFloatValueInput($this.attr('value'));
                } else {
                    moneyLimit[$this.attr('name')] = 0;
                }
            });
            if (isMoneyLimitSet) {
                data['money_limit'] = JSON.stringify(moneyLimit);
            } else {
                data['money_limit'] = null;
            }
        }
        
        
        // Обработка сообщений валидации:
        if ((data['user_id'] == 'new') && !data['user_name']) {warningInfo = 'Введите имя пользователя';}
        if ((data['user_id'] == 'new') && !data['user_email']) {warningInfo = 'Введите email пользователя';}
        if (data['user_id'] == 0) {warningInfo = 'Укажите пользователя';}
        if (!data['title'] || data['title'] == '') {warningInfo = 'Введите название группы кампаний';}
        
        if (warningInfo) {
            alert(warningInfo);
            return false;
        }
        
        //console.log('AAA ', data);
        //return false;
        
        $.ajax(action, {
            type: method,
            data: data,
            success: function(data) {
                if(data) {
                    if(data.result === true && data.redirect) {
                        document.location.href = data.redirect;
                    }
                    if(data.result === false && data.msg) {
                        $.showMessage('error', data.msg);
                    }
                } 
            },
            error: function(rew, status, err) {
                console.log(status, err);                    
            }
        });

        return false;
    });
    
    // Клик на "Отменить изменения"
    $btnCancelAction.on('click', function(e) {
        
        if ($(this).attr('disabled') == 'disabled') return false;
        
        var isChangedCurrent = isChanged;
        if (confirm((isCreatePage) ? 'Отменить создание группы кампаний?' : 'Отменить изменения в группе кампаний?')) {
            isChanged = false;
            if (isCreatePage) {
                document.location.href = $('.group-id').attr('href');
            } else {
                location.reload();
            }
        } else {
            isChanged = isChangedCurrent;
        }
        return false;
    });
    
    // Фильтрация в таблице:
    $('.panel-body').filterAmsystemTable({
        table: '.table.campaigns',
        selectStatus: '.form-control.campaign-status',
        currentFilterDefault: 'not-archive'
    });
    
    // Сортировка в таблице кампаний:
    if (!isCreatePage) {
        $('.table.campaigns').sortAmsystemTable();
    }
    
    
});

