<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Action;


use App\Entity\FAQ\Category;
use App\Model\FAQ\Categories;
use App\Model\FAQ\Items;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Zend\Diactoros\Response\HtmlResponse;

/**
 * Class FAQ
 * @package App\Action
 */
class FAQ extends Common
{

    /**
     * @param ServerRequestInterface $request
     * @param ResponseInterface $response
     * @param callable|null $next
     * @return HtmlResponse
     */
    function __invoke(ServerRequestInterface $request, ResponseInterface $response, callable $next = null)
    {

        $this->initInfo($request);

        /** @var Categories $categoriesModel */
        $categoriesModel = $this->container->get(Categories::class);
        /** @var Items $itemsModel */
        $itemsModel = $this->container->get(Items::class);

        $categoriesTmp = $categoriesModel->findAll();
        $categories = [];
        /** @var Category $category */
        foreach ($categoriesTmp as $category) {
            $categories[$category->getId()] = $category;
        }

        $items = $itemsModel->findAll(['faq_categories_id' => array_keys($categories)], 'faq_categories_id ASC, id ASC');

        $itemsGrouped = $itemsModel->makeGrouped($items);
        $data = [
            'categories' => $categories,
            'items' => $itemsGrouped,
            'lang' => $request->getAttribute('layoutInfo')->getLang(),
        ];

        return new HtmlResponse($this->template->render("app::faq", $data));
    }
}