<?php
/** @var \Interop\Container\ContainerInterface $container */
$container = include 'container.php';

$phinxconfig = $container->get('config')['phinx'];

/** @var \Zend\Db\Adapter\Adapter $adapter */
$adapter = $container->get(Zend\Db\Adapter\AdapterEcpa::class);


$connection = $adapter->getDriver()->getConnection();
// need that because phinx require estabilished \PDO connection
$connection->connect();

$reflection = new ReflectionObject($connection);

$resource = $reflection->getProperty('resource');
$resource->setAccessible(true);

$pdoConnection = $resource->getValue($connection);

// inject schema name from current connection
$dbName = $connection->getCurrentSchema();
$phinxconfig['environments']['development']['name'] = $dbName;

// if required replace that code with connection init depending on environment
array_walk_recursive($phinxconfig, function(&$value, $key, $connection) {
    if ($key == 'connection') {
        $value = $connection;
    }
}, $pdoConnection);

return $phinxconfig;