;(function($){

	var jqPluginName = 'filterAmsystemTable';

	var filterPlugin = function(element, options) {
            
            var self = this;

            var config = $.extend(true, {}, $.fn[jqPluginName].defaults, options);
            config.context = element;
            
            config.$table = $(config.table, config.context);
            config.$selectStatus = $(config.selectStatus, config.context);
            config.currentFilter = ($.cookie(config.cookieName)) ? $.cookie(config.cookieName) : config.currentFilterDefault;
            
            // Форматирование значений для таблицы
            this.valueFormatTable = function(value, currentActiveLine)
            {
                var
                    localeFormatter = d3.locale(config.myLocale),
                    format;
            
                switch(currentActiveLine) {
                    case 'money':
                    case 'order_money':
                    case 'cpc':
                    case 'cpm':
                        format = localeFormatter.numberFormat("$,.2f");
                    break;
                    case 'ctr':
                        format = function(d) { return d3.format(',.2f')(d) + "%"; };
                    break;
                    default:
                        format = localeFormatter.numberFormat(",.0f");
                    break;
                }

                return format(value);
            }
            
            this.setTableFilter = function(val) {
                config.$selectStatus.val(val);
                config.filters.forEach(function(item) {
                    config.$table.removeClass(item);
                })
                config.$table.addClass(val);
                $.cookie(config.cookieName, val, { expires : 365 });
            }
            
            this.setTotalValue = function(val) {
                
                var $totalTr = $('tr.total', config.$table);
            
                if ($totalTr.length > 0) {
                    
                    var
                        totalValue = [],
                        totalValueCat,
                        views, money, clicks;
                    
                    config.sumCats.forEach(function(cat){
                        totalValueCat = 0;
                        $('tbody tr.banner-item', config.$table).each(function(){
                            var $this = $(this);
                            if (val == 'all' || $this.hasClass(val)) {
                                totalValueCat+= parseFloat($('td.'+ cat, $this).data('value'));
                            }
                        });
                        totalValue[cat] = totalValueCat;
                    });
                    
                    views = totalValue['views'];
                    money = totalValue['money'];
                    clicks = totalValue['clicks'];
                    totalValue['ctr'] = (views != 0) ? ((clicks/views)*100).toFixed(2) : 0;
                    totalValue['cpm'] = (views != 0) ? ((money/views)*1000).toFixed(3) : 0;
                    totalValue['cpc'] = (clicks != 0) ? (money/clicks).toFixed(2) : 0;
                    
                    config.cats.forEach(function(cat){
                        $('tr.total td.' + cat, config.$table).html(self.valueFormatTable(totalValue[cat], cat));
                    });
                }
            }

            this.InitData = function() {
                this.setTableFilter(config.currentFilter);
                this.setTotalValue(config.currentFilter);
            }
            
            // Устанавливаем по-умолчанию фильтр для таблицы:
            this.InitData();
            
            config.$selectStatus.on('change', function(){
                self.setTableFilter($(this).val());
                self.setTotalValue($(this).val());
            });
            
            config.context.data(jqPluginName, this);
	}

	$.fn[jqPluginName] = function(options) {
            return this.each(function() {
                var _this = $(this);
                if (!_this.data(jqPluginName))
                {
                    new filterPlugin(_this, options);
                }
            });
	}

	$.fn[jqPluginName].defaults = {
            context: null,
            table: null,
            $table: null,
            selectStatus: null,
            $selectStatus: null,
            filters: ['all', 'active', 'not-active', 'archive', 'not-archive'],
            cookieName: 'table_filter_status',
            cats: ['views', 'clicks', 'ctr', 'cpm', 'cpc', 'money', 'order_cnt', 'order_money'],
            sumCats: ['views', 'clicks', 'money', 'order_cnt', 'order_money'],
            currentFilterDefault: 'all',
            myLocale: {
                "decimal": ",",
                "thousands": "\xa0",
                "grouping": [3],
                "currency": ["", " &#8372;"],
                "dateTime": "%A, %e %B %Y г. %X",
                "date": "%d.%m.%Y",
                "time": "%H:%M:%S",
                "periods": ["AM", "PM"],
                "days": ["воскресенье", "понедельник", "вторник", "среда", "четверг", "пятница", "суббота"],
                "shortDays": ["вс", "пн", "вт", "ср", "чт", "пт", "сб"],
                "months": ["января", "февраля", "марта", "апреля", "мая", "июня", "июля", "августа", "сентября", "октября", "ноября", "декабря"],
                "shortMonths": ["янв", "фев", "мар", "апр", "май", "июн", "июл", "авг", "сен", "окт", "ноя", "дек"]
            }
	}

})(jQuery);
