<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;

use App\Models\Sitecode;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Schema::defaultStringLength(191);
        \URL::forceScheme('https');
        
        view()->composer('*',function($view) {
            $view->with('sitecodes_header', Sitecode::where([['active', 1], ['place', 0]])->get());
            $view->with('sitecodes_footer', Sitecode::where([['active', 1], ['place', 1]])->get());
        });
    }
}
