<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    <title>@section('title')@show{{ config('project.title') }}</title>

    <meta content="" name="description">
    <meta content="" name="keywords">

    <!-- Favicons -->
    <link href="img/favicon.png" rel="icon">
    <link href="img/apple-touch-icon.png" rel="apple-touch-icon">

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Raleway:300,300i,400,400i,500,500i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

    <!-- CSS Files -->
    @include('layouts.styles')
  
    
</head>

<body>

    <!-- ======= Header ======= -->
    <header id="header" class="fixed-top">
        <div class="container d-flex align-items-center justify-content-between">
            <h1 class="logo"><a href="{{ route('home') }}">{{ config('project.name') }}</a></h1>

            @auth
                <a class="" href="{{ url('settings') }}">Налаштування</a>
                <a class="" href="{{ route('logout') }}">Вийти</a>
            @else
                <a class="" href="{{ route('login.create') }}">Вхiд</a>
                <a class="" href="{{ route('register.create') }}">Регiстрацiя</a>
            @endauth

            @yield('head_content')

        </div>
    </header><!-- End Header -->
  
    <main id="main">

        <div class="container">
            @include('layouts.alerts')
        </div>

        @yield('content')

    </main><!-- End #main -->

    @include('layouts.footer')

    <!-- JS Files -->
    @include('layouts.scripts')
  

</body>

</html>
