<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('home');
}) -> name('home');

Route::get('/register', [UserController::class, 'create']) -> name('register.create');
Route::post('/register', [UserController::class, 'store']) -> name('register.store');

Route::get('/login', [UserController::class, 'loginForm']) -> name('login.create');
Route::post('/login', [UserController::class, 'login']) -> name('login');
Route::get('/logout', [UserController::class, 'logout']) -> name('logout');

Route::get('/settings', [UserController::class, 'settings']) -> name('settings');


